/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MCC_MediumCopyCount
extends StructuredField {
    List<MCC_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = MCC_MediumCopyCount.getActualLength(sfData, offset, length);
        this.repeatingGroups = new ArrayList<MCC_RepeatingGroup>();
        for (int pos = 0; pos < actualLength; pos += 6) {
            MCC_RepeatingGroup rg = new MCC_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (MCC_RepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public List<MCC_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<MCC_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public void addRepeatingGroup(MCC_RepeatingGroup rg) {
        if (rg == null) {
            return;
        }
        if (this.repeatingGroups == null) {
            this.repeatingGroups = new ArrayList<MCC_RepeatingGroup>();
        }
        this.repeatingGroups.add(rg);
    }

    public void removeRepeatingGroup(MCC_RepeatingGroup rg) {
        if (this.repeatingGroups == null) {
            return;
        }
        this.repeatingGroups.remove(rg);
    }

    public static class MCC_RepeatingGroup
    implements IAFPDecodeableWriteable {
        short startingCopyNumber;
        short endingCopyNumber;
        byte reserved4 = 0;
        byte mediumModificationControlIdentifier;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 6);
            this.startingCopyNumber = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            this.endingCopyNumber = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.reserved4 = sfData[4];
            this.mediumModificationControlIdentifier = sfData[5];
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.startingCopyNumber, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.endingCopyNumber, 2));
            os.write(this.reserved4);
            os.write(this.mediumModificationControlIdentifier);
        }

        public short getStartingCopyNumber() {
            return this.startingCopyNumber;
        }

        public void setStartingCopyNumber(short startingCopyNumber) {
            this.startingCopyNumber = startingCopyNumber;
        }

        public short getEndingCopyNumber() {
            return this.endingCopyNumber;
        }

        public void setEndingCopyNumber(short endingCopyNumber) {
            this.endingCopyNumber = endingCopyNumber;
        }

        public byte getReserved4() {
            return this.reserved4;
        }

        public void setReserved4(byte reserved4) {
            this.reserved4 = reserved4;
        }

        public byte getMediumModificationControlIdentifier() {
            return this.mediumModificationControlIdentifier;
        }

        public void setMediumModificationControlIdentifier(byte mediumModificationControlIdentifier) {
            this.mediumModificationControlIdentifier = mediumModificationControlIdentifier;
        }
    }
}

