/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MCD_MapContainerData
extends StructuredField {
    short lengthOfRepeatingGroup;
    Triplet triplet;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        MCD_MapContainerData.checkDataLength(sfData, offset, length, 5);
        this.lengthOfRepeatingGroup = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        this.triplet = TripletParser.parseTriplet(sfData, offset, length, config);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilBinaryDecoding.shortToByteArray(this.lengthOfRepeatingGroup, 2));
        this.triplet.writeAFP(baos, config);
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public short getLengthOfRepeatingGroup() {
        return this.lengthOfRepeatingGroup;
    }

    public void setLengthOfRepeatingGroup(short lengthOfRepeatingGroup) {
        this.lengthOfRepeatingGroup = lengthOfRepeatingGroup;
    }

    public Triplet getTriplet() {
        return this.triplet;
    }

    public void setTriplet(Triplet triplet) {
        this.triplet = triplet;
    }
}

