/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPType;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MCF_MapCodedFont_Format1
extends StructuredField {
    short lengthOfRepeatingGroup;
    byte[] reserved1_3 = new byte[3];
    List<MCF_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.lengthOfRepeatingGroup = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        this.reserved1_3 = new byte[3];
        System.arraycopy(sfData, offset + 1, this.reserved1_3, 0, this.reserved1_3.length);
        int actualLength = MCF_MapCodedFont_Format1.getActualLength(sfData, offset, length);
        if (actualLength > 4) {
            this.repeatingGroups = new ArrayList<MCF_RepeatingGroup>((actualLength - 4) / this.lengthOfRepeatingGroup);
            for (int pos = 4; pos < actualLength; pos += this.lengthOfRepeatingGroup) {
                MCF_RepeatingGroup rg = new MCF_RepeatingGroup();
                rg.decodeAFP(sfData, offset + pos, this.lengthOfRepeatingGroup, config);
                this.repeatingGroups.add(rg);
            }
        } else {
            this.repeatingGroups = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.lengthOfRepeatingGroup);
        baos.write(this.reserved1_3);
        if (this.repeatingGroups != null) {
            for (MCF_RepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public short getLengthOfRepeatingGroup() {
        return this.lengthOfRepeatingGroup;
    }

    public void setLengthOfRepeatingGroup(short lengthOfRepeatingGroup) {
        this.lengthOfRepeatingGroup = lengthOfRepeatingGroup;
    }

    public byte[] getReserved1_3() {
        return this.reserved1_3;
    }

    public void setReserved1_3(byte[] reserved1_3) {
        this.reserved1_3 = reserved1_3;
    }

    public List<MCF_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<MCF_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public void addRepeatingGroup(MCF_RepeatingGroup repeatingGroup) {
        if (repeatingGroup == null) {
            return;
        }
        if (this.repeatingGroups == null) {
            this.repeatingGroups = new ArrayList<MCF_RepeatingGroup>();
        }
        this.repeatingGroups.add(repeatingGroup);
    }

    public void removeRepeatingGroup(MCF_RepeatingGroup repeatingGroup) {
        if (this.repeatingGroups == null) {
            return;
        }
        this.repeatingGroups.remove(repeatingGroup);
    }

    @AFPType
    public static class MCF_RepeatingGroup
    implements IAFPDecodeableWriteable {
        short codedFontLocalID;
        byte reserved1 = 0;
        short codedFontSectionID;
        byte reserved3 = 0;
        String codedFontName;
        byte[] codedFontNullName;
        String codePageName;
        byte[] codePageNullName;
        String fontCharacterSetName;
        byte[] fontCharacterSetNullName;
        AFPOrientation characterRotation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.codedFontLocalID = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.reserved1 = sfData[offset + 1];
            this.codedFontSectionID = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = sfData[offset + 3];
            int hint = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
            if (hint != 65535) {
                this.codedFontNullName = null;
                this.codedFontName = new String(sfData, offset + 4, 8, config.getAfpCharSet());
            } else {
                this.codedFontName = null;
                this.codedFontNullName = new byte[8];
                System.arraycopy(sfData, offset + 4, this.codedFontNullName, 0, this.codedFontNullName.length);
            }
            hint = UtilBinaryDecoding.parseInt(sfData, offset + 12, 2);
            if (hint != 65535) {
                this.codePageNullName = null;
                this.codePageName = new String(sfData, offset + 12, 8, config.getAfpCharSet());
            } else {
                this.codePageName = null;
                this.codePageNullName = new byte[8];
                System.arraycopy(sfData, offset + 12, this.codePageNullName, 0, this.codePageNullName.length);
            }
            hint = UtilBinaryDecoding.parseInt(sfData, offset + 20, 2);
            if (hint != 65535) {
                this.fontCharacterSetNullName = null;
                this.fontCharacterSetName = new String(sfData, offset + 20, 8, config.getAfpCharSet());
            } else {
                this.fontCharacterSetName = null;
                this.fontCharacterSetNullName = new byte[8];
                System.arraycopy(sfData, offset + 20, this.fontCharacterSetNullName, 0, this.fontCharacterSetNullName.length);
            }
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.characterRotation = actualLength == 30 ? AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 28, 2)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.codedFontLocalID);
            os.write(this.reserved1);
            os.write(this.codedFontSectionID);
            os.write(this.reserved3);
            if (this.codedFontName != null) {
                os.write(UtilCharacterEncoding.stringToByteArray(this.codedFontName, config.getAfpCharSet(), 8, (byte)64));
            } else {
                os.write(this.codedFontNullName);
            }
            if (this.codePageName != null) {
                os.write(UtilCharacterEncoding.stringToByteArray(this.codePageName, config.getAfpCharSet(), 8, (byte)64));
            } else {
                os.write(this.codePageNullName);
            }
            if (this.fontCharacterSetName != null) {
                os.write(UtilCharacterEncoding.stringToByteArray(this.fontCharacterSetName, config.getAfpCharSet(), 8, (byte)64));
            } else {
                os.write(this.fontCharacterSetNullName);
            }
            if (this.characterRotation != null) {
                os.write(this.characterRotation.toBytes());
            }
        }

        public short getCodedFontLocalID() {
            return this.codedFontLocalID;
        }

        public void setCodedFontLocalID(short codedFontLocalID) {
            this.codedFontLocalID = codedFontLocalID;
        }

        public byte getReserved1() {
            return this.reserved1;
        }

        public void setReserved1(byte reserved1) {
            this.reserved1 = reserved1;
        }

        public short getCodedFontSectionID() {
            return this.codedFontSectionID;
        }

        public void setCodedFontSectionID(short codedFontSectionID) {
            this.codedFontSectionID = codedFontSectionID;
        }

        public byte getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(byte reserved3) {
            this.reserved3 = reserved3;
        }

        public String getCodedFontName() {
            return this.codedFontName;
        }

        public void setCodedFontName(String codedFontName) {
            this.codedFontName = codedFontName;
        }

        public byte[] getCodedFontNullName() {
            return this.codedFontNullName;
        }

        public void setCodedFontNullName(byte[] codedFontNullName) {
            this.codedFontNullName = codedFontNullName;
        }

        public String getCodePageName() {
            return this.codePageName;
        }

        public void setCodePageName(String codePageName) {
            this.codePageName = codePageName;
        }

        public byte[] getCodePageNullName() {
            return this.codePageNullName;
        }

        public void setCodePageNullName(byte[] codePageNullName) {
            this.codePageNullName = codePageNullName;
        }

        public String getFontCharacterSetName() {
            return this.fontCharacterSetName;
        }

        public void setFontCharacterSetName(String fontCharacterSetName) {
            this.fontCharacterSetName = fontCharacterSetName;
        }

        public byte[] getFontCharacterSetNullName() {
            return this.fontCharacterSetNullName;
        }

        public void setFontCharacterSetNullName(byte[] fontCharacterSetNullName) {
            this.fontCharacterSetNullName = fontCharacterSetNullName;
        }

        public AFPOrientation getCharacterRotation() {
            return this.characterRotation;
        }

        public void setCharacterRotation(AFPOrientation characterRotation) {
            this.characterRotation = characterRotation;
        }
    }
}

