/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MDD_MediumDescriptor
extends StructuredFieldBaseTriplets {
    AFPUnitBase xUnitBase;
    AFPUnitBase yUnitBase;
    short xUnitsPerUnitBase;
    short yUnitsPerUnitBase;
    int xMediumExtent;
    int yMediumExtent;
    MDD_Flag flag;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.xUnitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 1]);
        this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.xMediumExtent = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
        this.yMediumExtent = UtilBinaryDecoding.parseInt(sfData, offset + 9, 3);
        this.flag = MDD_Flag.valueOf(sfData[offset + 12]);
        int actualLength = MDD_MediumDescriptor.getActualLength(sfData, offset, length);
        if (actualLength > 13) {
            super.decodeAFP(sfData, offset + 13, actualLength - 13, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.xUnitBase.toByte());
        baos.write(this.yUnitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xMediumExtent, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yMediumExtent, 3));
        baos.write(this.flag.toByte());
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getxUnitBase() {
        return this.xUnitBase;
    }

    public void setxUnitBase(AFPUnitBase xUnitBase) {
        this.xUnitBase = xUnitBase;
    }

    public AFPUnitBase getyUnitBase() {
        return this.yUnitBase;
    }

    public void setyUnitBase(AFPUnitBase yUnitBase) {
        this.yUnitBase = yUnitBase;
    }

    public short getxUnitsPerUnitBase() {
        return this.xUnitsPerUnitBase;
    }

    public void setxUnitsPerUnitBase(short xUnitsPerUnitBase) {
        this.xUnitsPerUnitBase = xUnitsPerUnitBase;
    }

    public short getyUnitsPerUnitBase() {
        return this.yUnitsPerUnitBase;
    }

    public void setyUnitsPerUnitBase(short yUnitsPerUnitBase) {
        this.yUnitsPerUnitBase = yUnitsPerUnitBase;
    }

    public int getxMediumExtent() {
        return this.xMediumExtent;
    }

    public void setxMediumExtent(int xMediumExtent) {
        this.xMediumExtent = xMediumExtent;
    }

    public int getyMediumExtent() {
        return this.yMediumExtent;
    }

    public void setyMediumExtent(int yMediumExtent) {
        this.yMediumExtent = yMediumExtent;
    }

    public MDD_Flag getFlag() {
        return this.flag;
    }

    public void setFlag(MDD_Flag flag) {
        this.flag = flag;
    }

    public static enum MDD_Flag {
        DoNotPassMediumOrientationToCutsheetPrinter,
        PassMediumOrientationToCutsheetPrinter;


        public static MDD_Flag valueOf(byte codeByte) {
            if ((codeByte & 0x80) == 0) {
                return DoNotPassMediumOrientationToCutsheetPrinter;
            }
            return PassMediumOrientationToCutsheetPrinter;
        }

        public int toByte() {
            if (this == DoNotPassMediumOrientationToCutsheetPrinter) {
                return 0;
            }
            return 128;
        }
    }
}

