/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IRepeatingGroup;
import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.StructuredFieldBaseRepeatingGroups;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MPS_MapPageSegment
extends StructuredFieldBaseRepeatingGroups {
    short lengthOfRepeatingGroup;
    byte[] reserved1_3 = new byte[3];

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.lengthOfRepeatingGroup = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        this.reserved1_3 = new byte[3];
        System.arraycopy(sfData, offset + 1, this.reserved1_3, 0, this.reserved1_3.length);
        int actualLength = MPS_MapPageSegment.getActualLength(sfData, offset, length);
        if (actualLength > 4) {
            for (int pos = 4; pos < actualLength; pos += this.lengthOfRepeatingGroup) {
                MPS_RepeatingGroup rg = new MPS_RepeatingGroup();
                rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
                this.addRepeatingGroup(rg);
            }
        } else {
            this.repeatingGroups = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.lengthOfRepeatingGroup);
        baos.write(this.reserved1_3);
        if (this.repeatingGroups != null) {
            for (IRepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public short getLengthOfRepeatingGroup() {
        return this.lengthOfRepeatingGroup;
    }

    public void setLengthOfRepeatingGroup(short lengthOfRepeatingGroup) {
        this.lengthOfRepeatingGroup = lengthOfRepeatingGroup;
    }

    public byte[] getReserved1_3() {
        return this.reserved1_3;
    }

    public void setReserved1_3(byte[] reserved1_3) {
        this.reserved1_3 = reserved1_3;
    }

    public static class MPS_RepeatingGroup
    implements IRepeatingGroup {
        byte[] reserved0_3 = new byte[4];
        String nameOfPageSegment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 12);
            this.reserved0_3 = new byte[4];
            System.arraycopy(sfData, offset, this.reserved0_3, 0, this.reserved0_3.length);
            this.nameOfPageSegment = new String(sfData, offset + 4, 8, config.getAfpCharSet());
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.reserved0_3);
            os.write(UtilCharacterEncoding.stringToByteArray(this.nameOfPageSegment, config.getAfpCharSet(), 8, (byte)64));
        }
    }
}

