/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PFC_PresentationFidelityControl
extends StructuredFieldBaseTriplets {
    byte reserved0 = 0;
    PFC_Flag flag;
    byte[] reserved2_3 = new byte[2];

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.reserved0 = sfData[offset];
        this.flag = PFC_Flag.valueOf(sfData[offset + 1]);
        this.reserved2_3 = new byte[2];
        System.arraycopy(sfData, offset + 2, this.reserved2_3, 0, this.reserved2_3.length);
        int actualLength = PFC_PresentationFidelityControl.getActualLength(sfData, offset, length);
        if (actualLength > 4) {
            super.decodeAFP(sfData, offset + 4, actualLength - 4, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.reserved0);
        baos.write(this.flag.toByte());
        baos.write(this.reserved2_3);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getReserved0() {
        return this.reserved0;
    }

    public void setReserved0(byte reserved0) {
        this.reserved0 = reserved0;
    }

    public PFC_Flag getFlag() {
        return this.flag;
    }

    public void setFlag(PFC_Flag flag) {
        this.flag = flag;
    }

    public byte[] getReserved2_3() {
        return this.reserved2_3;
    }

    public void setReserved2_3(byte[] reserved2_3) {
        this.reserved2_3 = reserved2_3;
    }

    public static enum PFC_Flag {
        ResetFidelityControlsToDefault,
        DoNotResetFidelityControlsToDefault;


        public static PFC_Flag valueOf(byte flagByte) {
            if ((flagByte & 0x80) == 0) {
                return ResetFidelityControlsToDefault;
            }
            return DoNotResetFidelityControlsToDefault;
        }

        public int toByte() {
            if (this == ResetFidelityControlsToDefault) {
                return 0;
            }
            return 128;
        }
    }
}

