/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IRepeatingGroup;
import com.mgz.afp.base.RepeatingGroupBase;
import com.mgz.afp.base.StructuredFieldBaseRepeatingGroups;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class PGP_PagePosition_Format2
extends StructuredFieldBaseRepeatingGroups {
    byte constant0;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        PGP_RepeatingGroup rg;
        this.constant0 = sfData[offset];
        int actualLength = PGP_PagePosition_Format2.getActualLength(sfData, offset, length);
        for (int pos = 1; pos < actualLength; pos += rg.getRepeatingGroupLength()) {
            rg = new PGP_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.addRepeatingGroup(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.constant0);
        for (IRepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getConstant0() {
        return this.constant0;
    }

    public void setConstant0(byte constant0) {
        this.constant0 = constant0;
    }

    public static class PGP_RepeatingGroup
    extends RepeatingGroupBase {
        int xOrigin;
        int yOrigin;
        AFPOrientation xRotation;
        PGP_SheetSideAndPartitionSelection sheetSideAndPartitionSelection;
        EnumSet<PGP_RGFlag> flags;
        Byte pageModififationControlID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 1, 3);
            this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 4, 3);
            this.xRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 7, 2));
            this.sheetSideAndPartitionSelection = PGP_SheetSideAndPartitionSelection.valueOf(sfData[offset + 9]);
            this.flags = this.repeatingGroupLength > 10 ? PGP_RGFlag.valueOf(sfData[offset + 10]) : null;
            this.pageModififationControlID = this.repeatingGroupLength > 11 ? Byte.valueOf(sfData[offset + 11]) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            super.writeAFP(os, config);
            os.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
            os.write(this.xRotation.toBytes());
            os.write(this.sheetSideAndPartitionSelection.toByte());
            if (this.flags != null) {
                os.write(PGP_RGFlag.toByte(this.flags));
            }
            if (this.pageModififationControlID != null) {
                os.write(this.pageModififationControlID.byteValue());
            }
        }

        public int getxOrigin() {
            return this.xOrigin;
        }

        public void setxOrigin(int xOrigin) {
            this.xOrigin = xOrigin;
        }

        public int getyOrigin() {
            return this.yOrigin;
        }

        public void setyOrigin(int yOrigin) {
            this.yOrigin = yOrigin;
        }

        public AFPOrientation getxRotation() {
            return this.xRotation;
        }

        public void setxRotation(AFPOrientation xRotation) {
            this.xRotation = xRotation;
        }

        public PGP_SheetSideAndPartitionSelection getSheetSideAndPartitionSelection() {
            return this.sheetSideAndPartitionSelection;
        }

        public void setSheetSideAndPartitionSelection(PGP_SheetSideAndPartitionSelection sheetSideAndPartitionSelection) {
            this.sheetSideAndPartitionSelection = sheetSideAndPartitionSelection;
        }

        public EnumSet<PGP_RGFlag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<PGP_RGFlag> flags) {
            this.flags = flags;
        }

        public byte getPageModififationControlID() {
            return this.pageModififationControlID;
        }

        public void setPageModififationControlID(byte pageModififationControlID) {
            this.pageModififationControlID = pageModififationControlID;
        }

        public static enum PGP_RGFlag implements IMutualExclusiveGroupedFlag
        {
            VariablPageData_PresentVPDInPartiton(0),
            VariablPageData_DoNotPresentVPDInPartiton(0),
            PCMOverlay_PresentPCMOverlaysInPartition(1),
            PCMOverlay_DoNotPresentPCMOverlaysInPartition(1),
            PCMOverlayPosition_PageOrigin(2),
            PCMOverlayPosition_PartitionOrigin(2),
            PageViewControl_IntendedForViewing(3),
            PageViewControl_NotIntendedForViewing(3);

            static final MutualExclusiveGroupedFlagHandler<PGP_RGFlag> handler;
            int group;

            private PGP_RGFlag(int group) {
                this.group = group;
            }

            public static void setFlag(EnumSet<PGP_RGFlag> flags, PGP_RGFlag flag) {
                handler.setFlag(flags, flag);
            }

            public static EnumSet<PGP_RGFlag> valueOf(byte codeByte) {
                EnumSet<PGP_RGFlag> result = EnumSet.noneOf(PGP_RGFlag.class);
                if ((codeByte & 0x80) == 0) {
                    result.add(VariablPageData_PresentVPDInPartiton);
                } else {
                    result.add(VariablPageData_DoNotPresentVPDInPartiton);
                }
                if ((codeByte & 0x40) == 0) {
                    result.add(PCMOverlay_PresentPCMOverlaysInPartition);
                } else {
                    result.add(PCMOverlay_DoNotPresentPCMOverlaysInPartition);
                }
                if ((codeByte & 0x20) == 0) {
                    result.add(PCMOverlayPosition_PageOrigin);
                } else {
                    result.add(PCMOverlayPosition_PartitionOrigin);
                }
                if ((codeByte & 0x10) == 0) {
                    result.add(PageViewControl_IntendedForViewing);
                } else {
                    result.add(PageViewControl_NotIntendedForViewing);
                }
                return result;
            }

            public static int toByte(EnumSet<PGP_RGFlag> flags) {
                int result = 0;
                if (flags.contains(VariablPageData_DoNotPresentVPDInPartiton)) {
                    result |= 0x80;
                }
                if (flags.contains(PCMOverlay_DoNotPresentPCMOverlaysInPartition)) {
                    result |= 0x40;
                }
                if (flags.contains(PCMOverlayPosition_PartitionOrigin)) {
                    result |= 0x20;
                }
                if (flags.contains(PageViewControl_NotIntendedForViewing)) {
                    result |= 0x10;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }

        public static enum PGP_SheetSideAndPartitionSelection {
            PageFrontSideIfNoNUp_DefaultFrontSideIfNUp(0),
            PageBackSideIfNoNUp_DefaultBackSideIfNup(1),
            Partition1_FrontSide(16),
            Partition1_BackSide(17),
            Partition2_FrontSide(32),
            Partition2_BackSide(33),
            Partition3_FrontSide(48),
            Partition3_BackSide(49),
            Partition4_FrontSide(64),
            Partition4_BackSide(65);

            int code;

            private PGP_SheetSideAndPartitionSelection(int code) {
                this.code = code;
            }

            public static PGP_SheetSideAndPartitionSelection valueOf(byte codeByte) {
                for (PGP_SheetSideAndPartitionSelection ssps : PGP_SheetSideAndPartitionSelection.values()) {
                    if (ssps.code != codeByte) continue;
                    return ssps;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }
}

