/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PMC_PageModificationControl
extends StructuredFieldBaseTriplets {
    byte pageModificationControlID;
    byte reserved1 = 0;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.pageModificationControlID = sfData[offset];
        this.reserved1 = sfData[offset + 1];
        int actualLenth = PMC_PageModificationControl.getActualLength(sfData, offset, length);
        if (actualLenth > 2) {
            super.decodeAFP(sfData, offset + 2, actualLenth - 2, config);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.pageModificationControlID);
        baos.write(this.reserved1);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getPageModificationControlID() {
        return this.pageModificationControlID;
    }

    public void setPageModificationControlID(byte pageModificationControlID) {
        this.pageModificationControlID = pageModificationControlID;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte reserved1) {
        this.reserved1 = reserved1;
    }
}

