/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IRepeatingGroup;
import com.mgz.afp.base.RepeatingGroupWithTriplets;
import com.mgz.afp.base.StructuredFieldBaseRepeatingGroups;
import com.mgz.afp.enums.AFPObjectType;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class PPO_PreprocessPresentationObject
extends StructuredFieldBaseRepeatingGroups {
    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        PPO_RepeatingGroup rg;
        int actualLength = PPO_PreprocessPresentationObject.getActualLength(sfData, offset, length);
        for (int pos = 0; pos < actualLength; pos += rg.getRepeatingGroupLength()) {
            rg = new PPO_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.addRepeatingGroup(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (IRepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public static class PPO_RepeatingGroup
    extends RepeatingGroupWithTriplets {
        AFPObjectType objectType;
        byte[] reserved3_4 = new byte[2];
        EnumSet<PPO_Flag> flags;
        int xOrigin;
        int yOrigin;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.repeatingGroupLength = UtilBinaryDecoding.parseInt(sfData, offset, 2);
            this.objectType = AFPObjectType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 1, 2));
            this.reserved3_4 = new byte[2];
            System.arraycopy(sfData, offset + 3, this.reserved3_4, 0, this.reserved3_4.length);
            this.flags = PPO_Flag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 5, 1));
            this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
            this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 9, 3);
            this.triplets = TripletParser.parseTriplets(sfData, offset + 12, -1, config);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.intToByteArray(this.repeatingGroupLength, 2));
            os.write(this.objectType.toByte());
            os.write(this.reserved3_4);
            os.write(PPO_Flag.toByte(this.flags));
            os.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
            for (Triplet t : this.triplets) {
                t.writeAFP(os, config);
            }
        }

        public void setFlag(PPO_Flag flag) {
            if (this.flags == null) {
                this.flags = EnumSet.noneOf(PPO_Flag.class);
            }
            PPO_Flag.setFlag(this.flags, flag);
        }

        public AFPObjectType getObjectType() {
            return this.objectType;
        }

        public void setObjectType(AFPObjectType objectType) {
            this.objectType = objectType;
        }

        public byte[] getReserved3_4() {
            return this.reserved3_4;
        }

        public void setReserved3_4(byte[] reserved3_4) {
            this.reserved3_4 = reserved3_4;
        }

        public EnumSet<PPO_Flag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<PPO_Flag> flags) {
            this.flags = flags;
        }

        public int getxOrigin() {
            return this.xOrigin;
        }

        public void setxOrigin(int xOrigin) {
            this.xOrigin = xOrigin;
        }

        public int getyOrigin() {
            return this.yOrigin;
        }

        public void setyOrigin(int yOrigin) {
            this.yOrigin = yOrigin;
        }

        public static enum PPO_Flag implements IMutualExclusiveGroupedFlag
        {
            ObjectOrientation_0Deg_DoNotPreprocess(0),
            ObjectOrientation_0Deg_Preprocess(0),
            ObjectOrientation_90Deg_DoNotPreprocess(1),
            ObjectOrientation_90Deg_Preprocess(1),
            ObjectOrientation_180Deg_DoNotPreprocess(2),
            ObjectOrientation_180Deg_Preprocess(2),
            ObjectOrientation_270Deg_DoNotPreprocess(3),
            ObjectOrientation_270Deg_Preprocess(3),
            PreprocessObjects_OnlySelected(4),
            PreprocessObjects_All(4);

            static MutualExclusiveGroupedFlagHandler<PPO_Flag> handler;
            int group;

            private PPO_Flag(int group) {
                this.group = group;
            }

            public static EnumSet<PPO_Flag> valueOf(short flagByte) {
                EnumSet<PPO_Flag> result = EnumSet.noneOf(PPO_Flag.class);
                if ((flagByte & 0x80) == 0) {
                    result.add(ObjectOrientation_0Deg_DoNotPreprocess);
                } else {
                    result.add(ObjectOrientation_0Deg_Preprocess);
                }
                if ((flagByte & 0x40) == 0) {
                    result.add(ObjectOrientation_90Deg_DoNotPreprocess);
                } else {
                    result.add(ObjectOrientation_90Deg_Preprocess);
                }
                if ((flagByte & 0x20) == 0) {
                    result.add(ObjectOrientation_180Deg_DoNotPreprocess);
                } else {
                    result.add(ObjectOrientation_180Deg_Preprocess);
                }
                if ((flagByte & 0x10) == 0) {
                    result.add(ObjectOrientation_270Deg_DoNotPreprocess);
                } else {
                    result.add(ObjectOrientation_270Deg_Preprocess);
                }
                if ((flagByte & 8) == 0) {
                    result.add(PreprocessObjects_OnlySelected);
                } else {
                    result.add(PreprocessObjects_All);
                }
                return result;
            }

            public static int toByte(EnumSet<PPO_Flag> flags) {
                int result = 0;
                if (flags.contains(ObjectOrientation_0Deg_Preprocess)) {
                    result |= 0x80;
                }
                if (flags.contains(ObjectOrientation_90Deg_Preprocess)) {
                    result |= 0x40;
                }
                if (flags.contains(ObjectOrientation_180Deg_Preprocess)) {
                    result |= 0x20;
                }
                if (flags.contains(ObjectOrientation_270Deg_Preprocess)) {
                    result |= 0x10;
                }
                if (flags.contains(PreprocessObjects_All)) {
                    result |= 8;
                }
                return result;
            }

            public static void setFlag(EnumSet<PPO_Flag> flags, PPO_Flag flag) {
                handler.setFlag(flags, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }
    }
}

