/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca_L;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.IOException;
import java.io.OutputStream;

public class CAT_ColorAttributeTable
extends StructuredField {
    CAT_BasePart basePart;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
    }

    public static class CAT_BasePart
    implements IAFPDecodeableWriteable {
        ResetLCTFlag resetLCTFlag;
        byte reserved1 = 0;
        short colorTableLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 3);
            this.resetLCTFlag = ResetLCTFlag.valueOf(sfData[offset]);
            this.reserved1 = sfData[offset + 1];
            this.colorTableLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.resetLCTFlag.toByte());
            os.write(this.reserved1);
            os.write(this.colorTableLocalID);
        }

        public ResetLCTFlag getResetLCTFlag() {
            return this.resetLCTFlag;
        }

        public void setResetLCTFlag(ResetLCTFlag resetLCTFlag) {
            this.resetLCTFlag = resetLCTFlag;
        }

        public byte getReserved1() {
            return this.reserved1;
        }

        public void setReserved1(byte reserved1) {
            this.reserved1 = reserved1;
        }

        public short getColorTableLocalID() {
            return this.colorTableLocalID;
        }

        public void setColorTableLocalID(short colorTableLocalID) {
            this.colorTableLocalID = colorTableLocalID;
        }

        public static enum ResetLCTFlag {
            DoNotResetLCT,
            ResetLCT;


            public static ResetLCTFlag valueOf(byte flagByte) {
                if (flagByte == 0) {
                    return DoNotResetLCT;
                }
                return ResetLCT;
            }

            public int toByte() {
                if (this == DoNotResetLCT) {
                    return 0;
                }
                return 128;
            }
        }
    }
}

