/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.parser;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.StructuredFieldBaseData;
import com.mgz.afp.base.StructuredFieldErrornouslyBuilt;
import com.mgz.afp.base.StructuredFieldIntroducer;
import com.mgz.afp.base.Undefined;
import com.mgz.afp.bcoca.BDD_BarCodeDataDescriptor;
import com.mgz.afp.enums.SFFlag;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.foca.CPC_CodePageControl;
import com.mgz.afp.foca.CPD_CodePageDescriptor;
import com.mgz.afp.foca.FNC_FontControl;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import java.io.IOException;
import java.io.InputStream;

public class AFPParser {
    private static String afpPackagePrefix = "com.mgz.afp.";
    private static String[] afpPackages = new String[]{afpPackagePrefix + "modca.", afpPackagePrefix + "ptoca.", afpPackagePrefix + "foca.", afpPackagePrefix + "ioca.", afpPackagePrefix + "goca.", afpPackagePrefix + "bcoca.", afpPackagePrefix + "lineData.", afpPackagePrefix + "modca_L."};
    AFPParserConfiguration parserConf;
    long nrOfBytesRead = 0L;
    long nrOfSFBuilt = 0L;
    long nrOfErrSFBuilt = 0L;

    public AFPParser(AFPParserConfiguration parserConfiguration) {
        this.parserConf = parserConfiguration;
    }

    public static StructuredField createSFInstance(StructuredFieldIntroducer sfi) {
        StructuredField sf = null;
        for (String afpPackage : afpPackages) {
            try {
                String className = afpPackage + sfi.getSFTypeID().name();
                Class<?> clazz = Class.forName(className);
                sf = (StructuredField)clazz.newInstance();
            }
            catch (Exception cnfex) {
                // empty catch block
            }
        }
        if (sf == null) {
            sf = new Undefined();
        }
        sf.setStructuredFieldIntroducer(sfi);
        return sf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload(StructuredField sf) throws AFPParserException {
        if (sf == null || sf.getStructuredFieldIntroducer() == null) {
            return;
        }
        StructuredFieldIntroducer sfi = sf.getStructuredFieldIntroducer();
        AFPParserConfiguration conf = sfi.getActualConfig();
        if (conf.getAFPFile() == null) {
            throw new AFPParserException("The file from whitch the structured field has been loaded is unknown.");
        }
        AFPParserConfiguration aFPParserConfiguration = conf;
        synchronized (aFPParserConfiguration) {
            InputStream is = null;
            try {
                conf.setInputStream(null);
                is = conf.getInputStream();
                long lenSFI = sfi.getFileOffset() + 1L + (long)sfi.getLengthOfStructuredFieldIntroducerIncludingExtension();
                if (is.skip(lenSFI) < lenSFI) {
                    throw new AFPParserException("Failed to skip over SF Introducer.");
                }
                int lenOfGrossPayload = sfi.getSFLength() - sfi.getLengthOfStructuredFieldIntroducerIncludingExtension();
                byte[] grossPayload = new byte[lenOfGrossPayload];
                if (lenOfGrossPayload > 0) {
                    byte[] padding;
                    byte[] sfData;
                    int len;
                    for (int read = 0; read < lenOfGrossPayload; read += len) {
                        len = is.read(grossPayload, read, lenOfGrossPayload - read);
                        if (len != -1) continue;
                        throw new AFPParserException("Reached end of file before end of structured field.");
                    }
                    if (sfi.isFlagSet(SFFlag.isPadded)) {
                        int lenOfPadding = grossPayload[grossPayload.length - 1];
                        if (lenOfPadding == 0) {
                            lenOfPadding = UtilBinaryDecoding.parseInt(grossPayload, grossPayload.length - 3, 2);
                        }
                        int lenOfSFData = lenOfGrossPayload - lenOfPadding;
                        sfData = new byte[lenOfSFData];
                        padding = new byte[lenOfPadding];
                        System.arraycopy(grossPayload, 0, sfData, 0, lenOfSFData);
                        System.arraycopy(grossPayload, lenOfSFData, padding, 0, lenOfPadding);
                    } else {
                        sfData = grossPayload;
                        padding = null;
                    }
                    sf.setPadding(padding);
                    sf.decodeAFP(sfData, 0, -1, conf);
                }
            }
            catch (Throwable th) {
                if (th instanceof AFPParserException) {
                    throw (AFPParserException)th;
                }
                throw new AFPParserException("Reload failed.", th);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                        conf.setInputStream(null);
                    }
                    catch (IOException e) {
                        throw new AFPParserException("Failed to close input stream.", e);
                    }
                }
            }
        }
    }

    public final StructuredField parseNextSF() throws AFPParserException {
        StructuredFieldIntroducer sfi = null;
        StructuredFieldErrornouslyBuilt errSf = null;
        try {
            int tmp;
            InputStream is = this.parserConf.getInputStream();
            do {
                if ((tmp = is.read()) == -1) continue;
                ++this.nrOfBytesRead;
            } while (tmp != Constants.AFPBeginByte_0xA5 && tmp != -1);
            if (tmp != -1) {
                StructuredField sf;
                block27: {
                    sfi = StructuredFieldIntroducer.parse(is);
                    sfi.setFileOffset(this.nrOfBytesRead - 1L);
                    if (this.parserConf.isParseToStructuredFieldsBaseData) {
                        sf = new StructuredFieldBaseData();
                        sf.setStructuredFieldIntroducer(sfi);
                    } else {
                        sf = AFPParser.createSFInstance(sfi);
                    }
                    int lenOfGrossPayload = sfi.getSFLength() - sfi.getLengthOfStructuredFieldIntroducerIncludingExtension();
                    if (this.parserConf.isBuildShallow()) {
                        AFPParserConfiguration actualConf = this.parserConf.clone();
                        actualConf.setInputStream(null);
                        sfi.setActualConfig(actualConf);
                        if (is.skip(lenOfGrossPayload) < (long)lenOfGrossPayload) {
                            throw new AFPParserException("Failed to skip payload while building shallow objects.");
                        }
                    } else {
                        byte[] grossPayload = new byte[lenOfGrossPayload];
                        try {
                            if (lenOfGrossPayload > 0) {
                                byte[] padding;
                                byte[] sfData;
                                int len;
                                for (int read = 0; read < lenOfGrossPayload; read += len) {
                                    len = is.read(grossPayload, read, lenOfGrossPayload - read);
                                    if (len != -1) continue;
                                    throw new AFPParserException("Reached end of file before end of structured field.");
                                }
                                if (sfi.isFlagSet(SFFlag.isPadded)) {
                                    int lenOfPadding = grossPayload[grossPayload.length - 1];
                                    if (lenOfPadding == 0) {
                                        lenOfPadding = UtilBinaryDecoding.parseInt(grossPayload, grossPayload.length - 3, 2);
                                    }
                                    int lenOfSFData = lenOfGrossPayload - lenOfPadding;
                                    sfData = new byte[lenOfSFData];
                                    padding = new byte[lenOfPadding];
                                    System.arraycopy(grossPayload, 0, sfData, 0, lenOfSFData);
                                    System.arraycopy(grossPayload, lenOfSFData, padding, 0, lenOfPadding);
                                } else {
                                    sfData = grossPayload;
                                    padding = null;
                                }
                                sf.setPadding(padding);
                                sf.decodeAFP(sfData, 0, -1, this.parserConf);
                            }
                        }
                        catch (Throwable th) {
                            errSf = new StructuredFieldErrornouslyBuilt();
                            sf = errSf;
                            errSf.setCausingException(th);
                            errSf.setStructuredFieldIntroducer(sfi);
                            errSf.setData(grossPayload);
                            if (!this.parserConf.isEscalateParsingErrors()) break block27;
                            throw th;
                        }
                    }
                }
                if (sf != null) {
                    if (sf instanceof FNC_FontControl) {
                        this.parserConf.setCurrentFontControl((FNC_FontControl)sf);
                    } else if (sf instanceof CPD_CodePageDescriptor) {
                        this.parserConf.setCurrentCodePageDescriptor((CPD_CodePageDescriptor)sf);
                    } else if (sf instanceof CPC_CodePageControl) {
                        this.parserConf.setCurrentPageControl((CPC_CodePageControl)sf);
                    } else if (sf instanceof BDD_BarCodeDataDescriptor) {
                        this.parserConf.setCurrentBarCodeDataDescriptor((BDD_BarCodeDataDescriptor)sf);
                    }
                    this.nrOfBytesRead += (long)sf.getStructuredFieldIntroducer().getSFLength();
                    ++this.nrOfSFBuilt;
                }
                return sf;
            }
            return null;
        }
        catch (Throwable e) {
            if (errSf == null) {
                errSf = new StructuredFieldErrornouslyBuilt();
                errSf.setStructuredFieldIntroducer(sfi);
            }
            this.nrOfBytesRead += (long)errSf.getStructuredFieldIntroducer().getSFLength();
            ++this.nrOfSFBuilt;
            ++this.nrOfErrSFBuilt;
            if (e instanceof AFPParserException) {
                ((AFPParserException)e).setErrornouslyBuiltStructuredField(errSf);
                this.error((AFPParserException)e);
            } else {
                AFPParserException afpex = new AFPParserException("An exception occured when parsing structured field at file index position 0x" + Long.toHexString(this.nrOfBytesRead) + ".", e);
                afpex.setErrornouslyBuiltStructuredField(errSf);
                this.error(afpex);
            }
            return errSf;
        }
    }

    public void error(AFPParserException afpExc) throws AFPParserException {
        throw afpExc;
    }

    public long getCountReadByte() {
        return this.nrOfBytesRead;
    }

    public void quitParsing() throws AFPParserException {
        this.parserConf.resetCurrentAFPObjects();
        if (this.parserConf.isParserOwnsInputStream && this.parserConf.inputStream != null) {
            try {
                this.parserConf.inputStream.close();
            }
            catch (IOException e) {
                throw new AFPParserException("Failed to close input stream.", e);
            }
        }
    }

    public long getNrOfSFBuilt() {
        return this.nrOfSFBuilt;
    }

    public long getNrOfSFBuiltWithErrors() {
        return this.nrOfErrSFBuilt;
    }
}

