/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ptoca.controlSequence;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.base.annotations.AFPType;
import com.mgz.afp.enums.AFPColorSpace;
import com.mgz.afp.enums.AFPColorValue;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

@AFPType
public abstract class PTOCAControlSequence
implements IAFPDecodeableWriteable {
    @AFPField(isHidden=true)
    ControlSequenceIntroducer csi;

    public ControlSequenceIntroducer getCsi() {
        return this.csi;
    }

    public void setCsi(ControlSequenceIntroducer csi) {
        this.csi = csi;
    }

    public static class USC_Underscore
    extends PTOCAControlSequence {
        PTOCA_BypassFlag bypassFlag;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.bypassFlag = PTOCA_BypassFlag.valueOf(sfData[offset]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.bypassFlag.toByte());
        }

        public PTOCA_BypassFlag getBypassFlag() {
            return this.bypassFlag;
        }

        public void setBypassFlag(PTOCA_BypassFlag bypassFlag) {
            this.bypassFlag = bypassFlag;
        }
    }

    public static class TRN_TransparentData
    extends PTOCAControlSequence {
        String transparentData;
        byte[] transparentDataEBCDIC;
        volatile boolean isUseEBCDICData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 0) {
                this.transparentDataEBCDIC = new byte[actualLength];
                System.arraycopy(sfData, offset, this.transparentDataEBCDIC, 0, actualLength);
                this.transparentData = new String(this.transparentDataEBCDIC, config.getAfpCharSet());
            } else {
                this.transparentData = null;
                this.transparentDataEBCDIC = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            if (this.isUseEBCDICData && this.transparentDataEBCDIC != null) {
                os.write(this.transparentDataEBCDIC);
            } else if (this.transparentData != null) {
                os.write(this.transparentData.getBytes(config.getAfpCharSet()));
            }
        }

        public String getTransparentData() {
            return this.transparentData;
        }

        public void setTransparentData(String transparentData) {
            this.transparentData = transparentData;
        }

        public byte[] getTransparentDataEBCDIC() {
            return this.transparentDataEBCDIC;
        }

        public void setTransparentDataEBCDIC(byte[] transparentDataEBCDIC) {
            this.transparentDataEBCDIC = transparentDataEBCDIC;
        }

        public boolean isUseEBCDICData() {
            return this.isUseEBCDICData;
        }

        public void setUseEBCDICData(boolean isUseEBCDICData) {
            this.isUseEBCDICData = isUseEBCDICData;
        }
    }

    public static class TBM_TemporaryBaselineMove
    extends PTOCAControlSequence {
        TBM_Direction direction;
        TBM_Precision precision;
        Short temporaryBaselineIncrement;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.direction = TBM_Direction.valueOf(sfData[offset]);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength >= 2) {
                this.precision = TBM_Precision.valueOf(sfData[offset + 1]);
                this.temporaryBaselineIncrement = actualLength >= 3 ? Short.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 2)) : null;
            } else {
                this.precision = null;
                this.temporaryBaselineIncrement = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.direction.toByte());
            if (this.precision != null) {
                os.write(this.precision.toByte());
                if (this.temporaryBaselineIncrement != null) {
                    os.write(UtilBinaryDecoding.shortToByteArray(this.temporaryBaselineIncrement, 2));
                }
            }
        }

        public TBM_Direction getDirection() {
            return this.direction;
        }

        public void setDirection(TBM_Direction direction) {
            this.direction = direction;
        }

        public TBM_Precision getPrecision() {
            return this.precision;
        }

        public void setPrecision(TBM_Precision precision) {
            this.precision = precision;
        }

        public Short getTemporaryBaselineIncrement() {
            return this.temporaryBaselineIncrement;
        }

        public void setTemporaryBaselineIncrement(Short temporaryBaselineIncrement) {
            this.temporaryBaselineIncrement = temporaryBaselineIncrement;
        }

        public static enum TBM_Precision {
            AccuratelyPlaced,
            MayBeSimulated;


            public static TBM_Precision valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 0) {
                    return AccuratelyPlaced;
                }
                if (codeByte == 1) {
                    return MayBeSimulated;
                }
                throw new AFPParserException("The TBM precision code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum TBM_Direction {
            DoNotChangeBaseline,
            ReturnToEstablishedBaseline,
            MoveAwayFromIAxis,
            MoveTowardIAxis;


            public static TBM_Direction valueOf(byte codeByte) throws AFPParserException {
                for (TBM_Direction dir : TBM_Direction.values()) {
                    if (dir.ordinal() != codeByte) continue;
                    return dir;
                }
                throw new AFPParserException("The TBM direction code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class SVI_SetVariableSpaceCharacterIncrement
    extends PTOCAControlSequence {
        short increment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.increment = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.increment, 2));
        }

        public short getIncrement() {
            return this.increment;
        }

        public void setIncrement(short increment) {
            this.increment = increment;
        }
    }

    public static class STO_SetTextOrientation
    extends PTOCAControlSequence {
        AFPOrientation xOrientation;
        AFPOrientation yOrientation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.xOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.yOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.xOrientation.toBytes());
            os.write(this.yOrientation.toBytes());
        }

        public AFPOrientation getxOrientation() {
            return this.xOrientation;
        }

        public void setxOrientation(AFPOrientation xOrientation) {
            this.xOrientation = xOrientation;
        }

        public AFPOrientation getyOrientation() {
            return this.yOrientation;
        }

        public void setyOrientation(AFPOrientation yOrientation) {
            this.yOrientation = yOrientation;
        }
    }

    public static class STC_SetTextColor
    extends PTOCAControlSequence {
        AFPColorValue foregroundColor;
        STC_Precision precision;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.foregroundColor = AFPColorValue.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.precision = StructuredField.getActualLength(sfData, offset, length) > 2 ? STC_Precision.valueOf(sfData[offset + 2]) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.foregroundColor.toByte2());
            if (this.precision != null) {
                os.write(this.precision.toByte());
            }
        }

        public AFPColorValue getForegroundColor() {
            return this.foregroundColor;
        }

        public void setForegroundColor(AFPColorValue foregroundColor) {
            this.foregroundColor = foregroundColor;
        }

        public STC_Precision getPrecision() {
            return this.precision;
        }

        public void setPrecision(STC_Precision precision) {
            this.precision = precision;
        }

        public static enum STC_Precision {
            IfSpecifiedColorNotSupported_EceptionAndDefault0xFF07,
            IfSpecifiedColorNotSupported_SubstitutColorOrDefaul0xFF07;


            public static STC_Precision valueOf(byte codeByte) {
                if (codeByte == 0) {
                    return IfSpecifiedColorNotSupported_EceptionAndDefault0xFF07;
                }
                return IfSpecifiedColorNotSupported_SubstitutColorOrDefaul0xFF07;
            }

            public int toByte() {
                if (this == IfSpecifiedColorNotSupported_EceptionAndDefault0xFF07) {
                    return 0;
                }
                return 1;
            }
        }
    }

    public static class SIM_SetInlineMargin
    extends PTOCAControlSequence {
        short displacement;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.displacement = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.displacement, 2));
        }

        public short getDisplacement() {
            return this.displacement;
        }

        public void setDisplacement(short displacement) {
            this.displacement = displacement;
        }
    }

    public static class SIA_SetIntercharacterAdjustment
    extends PTOCAControlSequence {
        short adjustment;
        SIA_Direction direction;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.adjustment = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            this.direction = StructuredField.getActualLength(sfData, offset, length) > 2 ? SIA_Direction.valueOf(sfData[offset + 1]) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.adjustment, 2));
            if (this.direction != null) {
                os.write(this.direction.toByte());
            }
        }

        public short getAdjustment() {
            return this.adjustment;
        }

        public void setAdjustment(short adjustment) {
            this.adjustment = adjustment;
        }

        public SIA_Direction getDirection() {
            return this.direction;
        }

        public void setDirection(SIA_Direction direction) {
            this.direction = direction;
        }

        public static enum SIA_Direction {
            PositiveIDirection,
            NegativeIDirection;


            public static SIA_Direction valueOf(byte codeByte) {
                if (codeByte == 0) {
                    return PositiveIDirection;
                }
                return NegativeIDirection;
            }

            public int toByte() {
                if (this == PositiveIDirection) {
                    return 0;
                }
                return 1;
            }
        }
    }

    public static class SEC_SetExtendedTextColor
    extends PTOCAControlSequence {
        byte reserved4 = 0;
        AFPColorSpace colorSpace;
        byte[] reserved6_9 = new byte[4];
        byte nrOfBitsComponent1;
        byte nrOfBitsComponent2;
        byte nrOfBitsComponent3;
        byte nrOfBitsComponent4;
        byte[] colorValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.reserved4 = sfData[offset];
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 1]);
            this.reserved6_9 = new byte[4];
            System.arraycopy(sfData, offset + 2, this.reserved6_9, 0, this.reserved6_9.length);
            this.nrOfBitsComponent1 = sfData[offset + 6];
            this.nrOfBitsComponent2 = sfData[offset + 7];
            this.nrOfBitsComponent3 = sfData[offset + 8];
            this.nrOfBitsComponent4 = sfData[offset + 9];
            this.colorValue = new byte[4];
            System.arraycopy(sfData, offset + 10, this.colorValue, 0, this.colorValue.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.reserved4);
            os.write(this.colorSpace.toByte());
            os.write(this.reserved6_9);
            os.write(this.nrOfBitsComponent1);
            os.write(this.nrOfBitsComponent2);
            os.write(this.nrOfBitsComponent3);
            os.write(this.nrOfBitsComponent4);
            os.write(this.colorValue);
        }

        public byte getReserved4() {
            return this.reserved4;
        }

        public void setReserved4(byte reserved4) {
            this.reserved4 = reserved4;
        }

        public AFPColorSpace getColorSpace() {
            return this.colorSpace;
        }

        public void setColorSpace(AFPColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public byte[] getReserved6_9() {
            return this.reserved6_9;
        }

        public void setReserved6_9(byte[] reserved6_9) {
            this.reserved6_9 = reserved6_9;
        }

        public byte getNrOfBitsComponent1() {
            return this.nrOfBitsComponent1;
        }

        public void setNrOfBitsComponent1(byte nrOfBitsComponent1) {
            this.nrOfBitsComponent1 = nrOfBitsComponent1;
        }

        public byte getNrOfBitsComponent2() {
            return this.nrOfBitsComponent2;
        }

        public void setNrOfBitsComponent2(byte nrOfBitsComponent2) {
            this.nrOfBitsComponent2 = nrOfBitsComponent2;
        }

        public byte getNrOfBitsComponent3() {
            return this.nrOfBitsComponent3;
        }

        public void setNrOfBitsComponent3(byte nrOfBitsComponent3) {
            this.nrOfBitsComponent3 = nrOfBitsComponent3;
        }

        public byte getNrOfBitsComponent4() {
            return this.nrOfBitsComponent4;
        }

        public void setNrOfBitsComponent4(byte nrOfBitsComponent4) {
            this.nrOfBitsComponent4 = nrOfBitsComponent4;
        }

        public byte[] getColorValue() {
            return this.colorValue;
        }

        public void setColorValue(byte[] colorValue) {
            this.colorValue = colorValue;
        }
    }

    public static class SCFL_SetCodedFontLocal
    extends PTOCAControlSequence {
        short codedFontLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.codedFontLocalID = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.intToByteArray(this.codedFontLocalID, 1));
        }

        public short getCodedFontLocalID() {
            return this.codedFontLocalID;
        }

        public void setCodedFontLocalID(short codedFontLocalID) {
            this.codedFontLocalID = codedFontLocalID;
        }
    }

    public static class SBI_SetBaselineIncrement
    extends PTOCAControlSequence {
        short increment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.increment = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.increment, 2));
        }

        public short getIncrement() {
            return this.increment;
        }

        public void setIncrement(short increment) {
            this.increment = increment;
        }
    }

    public static class RPS_RepeatString
    extends PTOCAControlSequence {
        short repeatLength;
        byte[] repeatData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.repeatLength = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            int actualLegth = StructuredField.getActualLength(sfData, offset, length);
            if (actualLegth > 2) {
                this.repeatData = new byte[actualLegth - 2];
                System.arraycopy(sfData, offset + 2, this.repeatData, 0, this.repeatData.length);
            } else {
                this.repeatData = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.repeatLength, 2));
            if (this.repeatData != null) {
                os.write(this.repeatData);
            }
        }

        public short getRepeatLength() {
            return this.repeatLength;
        }

        public void setRepeatLength(short repeatLength) {
            this.repeatLength = repeatLength;
        }

        public byte[] getRepeatData() {
            return this.repeatData;
        }

        public void setRepeatData(byte[] repeatData) {
            this.repeatData = repeatData;
        }

        public void setRepeatData(String data, Charset encoding) {
            this.repeatData = data.getBytes(encoding);
        }
    }

    public static class RMI_RelativeMoveInline
    extends PTOCAControlSequence {
        short increment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.increment = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.increment, 2));
        }

        public short getIncrement() {
            return this.increment;
        }

        public void setIncrement(short increment) {
            this.increment = increment;
        }
    }

    public static class RMB_RelativeMoveBaseline
    extends PTOCAControlSequence {
        short increment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.increment = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.increment, 2));
        }

        public short getIncrement() {
            return this.increment;
        }

        public void setIncrement(short increment) {
            this.increment = increment;
        }
    }

    public static class OVS_Overstrike
    extends PTOCAControlSequence {
        PTOCA_BypassFlag bypassFlag;
        int overStrikeCharacterCodePoint;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.bypassFlag = PTOCA_BypassFlag.valueOf(sfData[offset]);
            this.overStrikeCharacterCodePoint = UtilBinaryDecoding.parseInt(sfData, offset + 1, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.bypassFlag.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.overStrikeCharacterCodePoint, 2));
        }

        public PTOCA_BypassFlag getBypassFlag() {
            return this.bypassFlag;
        }

        public void setBypassFlag(PTOCA_BypassFlag bypassFlag) {
            this.bypassFlag = bypassFlag;
        }

        public int getOverStrikeCharacterCodePoint() {
            return this.overStrikeCharacterCodePoint;
        }

        public void setOverStrikeCharacterCodePoint(int overStrikeCharacterCodePoint) {
            this.overStrikeCharacterCodePoint = overStrikeCharacterCodePoint;
        }
    }

    public static class NOP_NoOperation
    extends PTOCAControlSequence {
        byte[] ignoredData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 0) {
                this.ignoredData = new byte[actualLength];
                System.arraycopy(sfData, offset, this.ignoredData, 0, actualLength);
            } else {
                this.ignoredData = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            if (this.ignoredData != null) {
                os.write(this.ignoredData);
            }
        }

        public byte[] getIgnoredData() {
            return this.ignoredData;
        }

        public void setIgnoredData(byte[] ignoredData) {
            this.ignoredData = ignoredData;
        }
    }

    public static class ESU_EndSuppression
    extends PTOCAControlSequence {
        short suppressionID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.suppressionID = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.suppressionID);
        }

        public short getSuppressionID() {
            return this.suppressionID;
        }

        public void setSuppressionID(short suppressionID) {
            this.suppressionID = suppressionID;
        }
    }

    public static class DIR_DrawIaxisRule
    extends PTOCAControlSequence {
        short length;
        Short width;
        Byte widthFraction;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.length = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 2) {
                this.width = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
                this.widthFraction = sfData[offset + 4];
            } else {
                this.width = null;
                this.widthFraction = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 2));
            if (this.width != null) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.width, 2));
                os.write(this.widthFraction != null ? (int)this.widthFraction.byteValue() : 0);
            }
        }

        public short getLength() {
            return this.length;
        }

        public void setLength(short length) {
            this.length = length;
        }

        public Short getWidth() {
            return this.width;
        }

        public void setWidth(Short width) {
            this.width = width;
        }

        public Byte getWidthFraction() {
            return this.widthFraction;
        }

        public void setWidthFraction(Byte widthFraction) {
            this.widthFraction = widthFraction;
        }
    }

    public static class DBR_DrawBaxisRule
    extends PTOCAControlSequence {
        short length;
        Short width;
        Byte widthFraction;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.length = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 1) {
                this.width = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
                this.widthFraction = sfData[offset + 4];
            } else {
                this.width = null;
                this.widthFraction = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 2));
            if (this.width != null) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.width, 2));
                os.write(this.widthFraction != null ? (int)this.widthFraction.byteValue() : 0);
            }
        }

        public short getLength() {
            return this.length;
        }

        public void setLength(short length) {
            this.length = length;
        }

        public Short getWidth() {
            return this.width;
        }

        public void setWidth(Short width) {
            this.width = width;
        }

        public Byte getWidthFraction() {
            return this.widthFraction;
        }

        public void setWidthFraction(Byte widthFraction) {
            this.widthFraction = widthFraction;
        }
    }

    public static class BSU_BeginSuppression
    extends PTOCAControlSequence {
        short suppressionID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.suppressionID = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.suppressionID);
        }

        public short getSuppressionID() {
            return this.suppressionID;
        }

        public void setSuppressionID(short suppressionID) {
            this.suppressionID = suppressionID;
        }
    }

    public static class BLN_BeginLine
    extends PTOCAControlSequence {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        }
    }

    public static class AMI_AbsoluteMoveInline
    extends PTOCAControlSequence {
        short displacement;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.displacement = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.displacement, 2));
        }

        public short getDisplacement() {
            return this.displacement;
        }

        public void setDisplacement(short displacement) {
            this.displacement = displacement;
        }
    }

    public static class AMB_AbsoluteMoveBaseline
    extends PTOCAControlSequence {
        short displacement;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.displacement = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.displacement, 2));
        }

        public short getDisplacement() {
            return this.displacement;
        }

        public void setDisplacement(short displacement) {
            this.displacement = displacement;
        }
    }

    public static class Undefined
    extends PTOCAControlSequence {
        @AFPField
        byte[] undefinedData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 0) {
                this.undefinedData = new byte[actualLength];
                System.arraycopy(sfData, offset, this.undefinedData, 0, actualLength);
            } else {
                this.undefinedData = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            if (this.undefinedData != null) {
                os.write(this.undefinedData);
            }
        }
    }

    public static class ControlSequenceIntroducer {
        short csPrefix;
        short csClass;
        short length;
        @AFPField(isEditable=false)
        ControlSequenceFunctionType controlSequenceFunctionType;
        short originalCSFT;
        volatile boolean isChained;

        public static ControlSequenceIntroducer parseCSI(boolean isChained, byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            ControlSequenceIntroducer csi = new ControlSequenceIntroducer();
            int pos = 0;
            if (isChained) {
                csi.csPrefix = (short)-1;
                csi.csClass = (short)-1;
            } else {
                csi.csPrefix = UtilBinaryDecoding.parseShort(sfData, offset, 1);
                csi.csClass = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
                pos = 2;
            }
            csi.length = UtilBinaryDecoding.parseShort(sfData, offset + pos, 1);
            short originalCSFT = UtilBinaryDecoding.parseShort(sfData, offset + pos + 1, 1);
            csi.controlSequenceFunctionType = ControlSequenceFunctionType.valueOf(originalCSFT);
            csi.isChained = (originalCSFT & 1) != 0;
            return csi;
        }

        public byte[] toBytes() {
            byte[] data = null;
            data = this.csPrefix == -1 && this.csClass == -1 ? new byte[]{(byte)this.length, (byte)this.controlSequenceFunctionType.toByte(this.isChained)} : new byte[]{(byte)this.csPrefix, (byte)this.csClass, (byte)this.length, (byte)this.controlSequenceFunctionType.toByte(this.isChained)};
            return data;
        }

        public short getCsPrefix() {
            return this.csPrefix;
        }

        public void setCsPrefix(short csPrefix) {
            this.csPrefix = csPrefix;
        }

        public short getCsClass() {
            return this.csClass;
        }

        public void setCsClass(short csClass) {
            this.csClass = csClass;
        }

        public short getLength() {
            return this.length;
        }

        public void setLength(short length) {
            this.length = length;
        }

        public ControlSequenceFunctionType getControlSequenceFunctionType() {
            return this.controlSequenceFunctionType;
        }

        public void setControlSequenceFunctionType(ControlSequenceFunctionType controlSequenceFunctionType) {
            this.controlSequenceFunctionType = controlSequenceFunctionType;
        }

        public boolean isChained() {
            return this.isChained;
        }

        public void setChained(boolean isChained) {
            this.isChained = isChained;
        }

        public short getOriginalCSFT() {
            return this.originalCSFT;
        }

        public void setOriginalCSFT(short originalCSFT) {
            this.originalCSFT = originalCSFT;
        }
    }

    public static enum PTOCA_BypassFlag {
        BypassRelativeMoveInline,
        BypassAbsoluteMoveInline,
        BypassSpaceCharactersVariableSpaceCharacters,
        NoBypass;


        public static PTOCA_BypassFlag valueOf(byte flagByte) {
            if ((flagByte & 8) == 8) {
                return BypassRelativeMoveInline;
            }
            if ((flagByte & 4) == 4) {
                return BypassAbsoluteMoveInline;
            }
            if ((flagByte & 2) == 2) {
                return BypassSpaceCharactersVariableSpaceCharacters;
            }
            if ((flagByte & 1) == 1) {
                return NoBypass;
            }
            return null;
        }

        public int toByte() {
            if (this == BypassRelativeMoveInline) {
                return 8;
            }
            if (this == BypassAbsoluteMoveInline) {
                return 4;
            }
            if (this == BypassSpaceCharactersVariableSpaceCharacters) {
                return 2;
            }
            return 1;
        }
    }

    public static enum ControlSequenceFunctionType {
        Undefined(0),
        SIM_SetInlineMargin(192),
        SIA_SetIntercharacterAdjustment(194),
        SVI_SetVariableSpaceCharacterIncrement(196),
        AMI_AbsoluteMoveInline(198),
        RMI_RelativeMoveInline(200),
        SBI_SetBaselineIncrement(208),
        AMB_AbsoluteMoveBaseline(210),
        RMB_RelativeMoveBaseline(212),
        BLN_BeginLine(216),
        STO_SetTextOrientation(246),
        TRN_TransparentData(218),
        RPS_RepeatString(238),
        NOP_NoOperation(248),
        DIR_DrawIaxisRule(228),
        DBR_DrawBaxisRule(230),
        STC_SetTextColor(116),
        SEC_SetExtendedTextColor(128),
        SCFL_SetCodedFontLocal(240),
        BSU_BeginSuppression(242),
        ESU_EndSuppression(244),
        OVS_Overstrike(114),
        USC_Underscore(118),
        TBM_TemporaryBaselineMove(120);

        int typeCode;

        private ControlSequenceFunctionType(int typeCode) {
            this.typeCode = typeCode;
        }

        public static ControlSequenceFunctionType valueOf(short typeCode) throws AFPParserException {
            for (ControlSequenceFunctionType csft : ControlSequenceFunctionType.values()) {
                if (csft.typeCode != typeCode && csft.typeCode != typeCode - 1) continue;
                return csft;
            }
            return Undefined;
        }

        public int toByte(boolean isChained) {
            return isChained ? this.typeCode + 1 : this.typeCode;
        }
    }
}

