/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.util;

import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.base.annotations.AFPType;
import com.mgz.afp.exceptions.AFPParserException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UtilReflection {
    public static final Comparator<Field> comparatorFields = new FieldComparator();
    private static AFPField annotationAFPField;
    public static final AFPField defaultAFPFieldAnnotation;

    public static Object getFieldValue(Field field, Object instance) throws AFPParserException {
        if (instance == null) {
            return null;
        }
        String errMsg = "";
        try {
            boolean isAccessable = field.isAccessible();
            field.setAccessible(true);
            Object val = field.get(instance);
            field.setAccessible(isAccessable);
            return val;
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            errMsg = e1.getMessage();
            String methodName = "get" + field.getName();
            Class<?> clazz = instance.getClass();
            for (Method method : clazz.getMethods()) {
                if (!methodName.equalsIgnoreCase(method.getName())) continue;
                Object returnValue = null;
                try {
                    returnValue = method.invoke(instance, new Object[0]);
                }
                catch (Throwable e) {
                    throw new AFPParserException("Failed to get value of field " + field.getName() + "\n" + errMsg, e);
                }
                return returnValue;
            }
            return null;
        }
    }

    public static void setFieldValue(Field field, Object instance, Object value) throws AFPParserException {
        try {
            boolean isAccessable = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(isAccessable);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            throw new AFPParserException("Failed to set value.", e1);
        }
    }

    public static boolean isNumeric(Class<?> fieldType) {
        return Number.class.isAssignableFrom(fieldType) || fieldType.isPrimitive() && (Double.TYPE.isAssignableFrom(fieldType) || Float.TYPE.isAssignableFrom(fieldType) || Long.TYPE.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType) || Short.TYPE.isAssignableFrom(fieldType) || Byte.TYPE.isAssignableFrom(fieldType));
    }

    public static boolean isAFPType(Class<?> clazz) {
        while (clazz != null && clazz != Object.class) {
            if (clazz.getAnnotation(AFPType.class) != null) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (field.getAnnotation(AFPField.class) == null) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static AFPField getAFPFieldDefaultAnnotation() {
        if (annotationAFPField != null) {
            return annotationAFPField;
        }
        AFPFieldAnnotationBearer afpFieldAnnotationBearer = new AFPFieldAnnotationBearer();
        annotationAFPField = afpFieldAnnotationBearer.getClass().getAnnotation(AFPField.class);
        return annotationAFPField;
    }

    public static List<Field> getAFPFields(Class<?> clazz) {
        AFPField defaultAnnotation = null;
        ArrayList listOfClasses = new ArrayList();
        while (clazz != null && clazz != Object.class) {
            listOfClasses.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<Field> listOfFields = new ArrayList<Field>();
        for (Class clazz2 : listOfClasses) {
            if (defaultAnnotation == null) {
                defaultAnnotation = clazz2.getAnnotation(AFPType.class) != null ? defaultAFPFieldAnnotation : defaultAnnotation;
            }
            for (Field field : clazz2.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                AFPField annotation = field.getAnnotation(AFPField.class);
                if (annotation == null) {
                    annotation = defaultAnnotation;
                }
                if (annotation == null || annotation.isHidden()) continue;
                listOfFields.add(field);
            }
        }
        Collections.sort(listOfFields, comparatorFields);
        return listOfFields;
    }

    static {
        defaultAFPFieldAnnotation = UtilReflection.getAFPFieldDefaultAnnotation();
    }

    public static class FieldComparator
    implements Comparator<Field> {
        private static final Map<String, Integer> specialOrderedFields = new HashMap<String, Integer>();

        public FieldComparator() {
            specialOrderedFields.put("extension", 1000);
            specialOrderedFields.put("padding", 1000);
        }

        private static Integer getOrder(String fieldName) {
            Integer order = specialOrderedFields.get(fieldName);
            if (order == null) {
                return 100;
            }
            return order;
        }

        @Override
        public int compare(Field o1, Field o2) {
            return FieldComparator.getOrder(o1.getName()).compareTo(FieldComparator.getOrder(o2.getName()));
        }
    }

    @AFPField
    private static class AFPFieldAnnotationBearer {
        private AFPFieldAnnotationBearer() {
        }
    }
}

