/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.config;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.grosner.dbflow.DatabaseHelperListener;
import com.grosner.dbflow.config.FlowSQLiteOpenHelper;
import com.grosner.dbflow.sql.migration.Migration;
import com.grosner.dbflow.structure.BaseModelView;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import com.grosner.dbflow.structure.ModelViewAdapter;
import com.grosner.dbflow.structure.container.ContainerAdapter;
import java.util.List;
import java.util.Map;

public abstract class BaseDatabaseDefinition {
    private FlowSQLiteOpenHelper mHelper;
    private DatabaseHelperListener mHelperListener;
    private boolean isResetting = false;
    private final DatabaseHelperListener mInternalHelperListener = new DatabaseHelperListener(){

        @Override
        public void onOpen(SQLiteDatabase database) {
            if (BaseDatabaseDefinition.this.mHelperListener != null) {
                BaseDatabaseDefinition.this.mHelperListener.onOpen(database);
            }
        }

        @Override
        public void onCreate(SQLiteDatabase database) {
            if (BaseDatabaseDefinition.this.mHelperListener != null) {
                BaseDatabaseDefinition.this.mHelperListener.onCreate(database);
            }
        }

        @Override
        public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
            if (BaseDatabaseDefinition.this.mHelperListener != null) {
                BaseDatabaseDefinition.this.mHelperListener.onUpgrade(database, oldVersion, newVersion);
            }
        }
    };

    abstract List<Class<? extends Model>> getModelClasses();

    abstract List<ModelAdapter> getModelAdapters();

    abstract ModelAdapter getModelAdapterForTable(Class<? extends Model> var1);

    public abstract ContainerAdapter getModelContainerAdapterForTable(Class<? extends Model> var1);

    abstract List<Class<? extends BaseModelView>> getModelViews();

    abstract ModelViewAdapter getModelViewAdapterForTable(Class<? extends BaseModelView> var1);

    abstract List<ModelViewAdapter> getModelViewAdapters();

    abstract Map<Integer, List<Migration>> getMigrations();

    public SQLiteDatabase getWritableDatabase() {
        if (this.mHelper == null) {
            this.mHelper = new FlowSQLiteOpenHelper(this, this.mInternalHelperListener);
        }
        return this.mHelper.getWritableDatabase();
    }

    public void setHelperListener(DatabaseHelperListener databaseHelperListener) {
        this.mHelperListener = databaseHelperListener;
    }

    public abstract String getDatabaseName();

    public abstract int getDatabaseVersion();

    public abstract boolean areConsistencyChecksEnabled();

    public abstract boolean isForeignKeysSupported();

    public void reset(Context context) {
        if (!this.isResetting) {
            this.isResetting = true;
            context.deleteDatabase(this.getDatabaseName());
            this.isResetting = false;
        }
    }
}

