/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.config;

import android.os.Build;
import android.util.Log;

public class FlowLog {
    public static final String TAG = FlowLog.class.getSimpleName();
    private static Level sLevel = Level.E;

    public static void setMinimumLoggingLevel(Level level) {
        sLevel = level;
    }

    public static void log(Level level, String message) {
        FlowLog.log(level, message, null);
    }

    public static void log(Level level, String message, Throwable throwable) {
        FlowLog.log(level, TAG, message, throwable);
    }

    public static void log(Level level, String tag, String message, Throwable throwable) {
        if (FlowLog.isEnabled(level)) {
            level.call(tag, message, throwable);
        }
    }

    public static boolean isEnabled(Level level) {
        return level.ordinal() >= sLevel.ordinal();
    }

    public static void logError(Throwable throwable) {
        FlowLog.log(Level.E, throwable);
    }

    public static void log(Level level, Throwable throwable) {
        FlowLog.log(level, TAG, "", throwable);
    }

    public static enum Level {
        V{

            @Override
            void call(String tag, String message, Throwable throwable) {
                Log.v((String)tag, (String)message, (Throwable)throwable);
            }
        }
        ,
        D{

            @Override
            void call(String tag, String message, Throwable throwable) {
                Log.d((String)tag, (String)message, (Throwable)throwable);
            }
        }
        ,
        I{

            @Override
            void call(String tag, String message, Throwable throwable) {
                Log.i((String)tag, (String)message, (Throwable)throwable);
            }
        }
        ,
        W{

            @Override
            void call(String tag, String message, Throwable throwable) {
                Log.w((String)tag, (String)message, (Throwable)throwable);
            }
        }
        ,
        E{

            @Override
            void call(String tag, String message, Throwable throwable) {
                Log.e((String)tag, (String)message, (Throwable)throwable);
            }
        }
        ,
        WTF{

            @Override
            void call(String tag, String message, Throwable throwable) {
                if (Build.VERSION.SDK_INT >= 8) {
                    Log.wtf((String)tag, (String)message, (Throwable)throwable);
                } else {
                    Log.e((String)tag, (String)("!!!!!!!!*******" + message + "********!!!!!!"), (Throwable)throwable);
                }
            }
        };


        abstract void call(String var1, String var2, Throwable var3);
    }
}

