/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.config;

import android.content.Context;
import com.grosner.dbflow.DatabaseHelperListener;
import com.grosner.dbflow.config.BaseDatabaseDefinition;
import com.grosner.dbflow.config.DatabaseHolder;
import com.grosner.dbflow.converter.TypeConverter;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.migration.Migration;
import com.grosner.dbflow.structure.BaseModelView;
import com.grosner.dbflow.structure.InvalidDBConfiguration;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import com.grosner.dbflow.structure.ModelViewAdapter;
import com.grosner.dbflow.structure.container.ContainerAdapter;
import java.util.List;
import java.util.Map;

public class FlowManager {
    private static Context context;
    private static DatabaseHolder mDatabaseHolder;

    public static String getTableName(Class<? extends Model> table) {
        ModelAdapter<? extends Model> modelAdapter = FlowManager.getModelAdapter(table);
        String tableName = null;
        if (modelAdapter == null) {
            ModelViewAdapter modelViewAdapter = FlowManager.getDatabaseForTable(table).getModelViewAdapterForTable(table);
            if (modelViewAdapter != null) {
                tableName = modelViewAdapter.getViewName();
            }
        } else {
            tableName = modelAdapter.getTableName();
        }
        return tableName;
    }

    public static BaseDatabaseDefinition getDatabaseForTable(Class<? extends Model> table) {
        FlowManager.getDatabaseHolder();
        BaseDatabaseDefinition flowManager = mDatabaseHolder.getDatabaseForTable(table);
        if (flowManager == null) {
            throw new InvalidDBConfiguration("Table: " + table.getName() + " is not registered with a Database. " + "Did you forget the @Table annotation?");
        }
        return flowManager;
    }

    public static BaseDatabaseDefinition getDatabase(String databaseName) {
        FlowManager.getDatabaseHolder();
        BaseDatabaseDefinition flowManager = mDatabaseHolder.getDatabase(databaseName);
        if (flowManager == null) {
            throw new InvalidDBConfiguration();
        }
        return flowManager;
    }

    protected static DatabaseHolder getDatabaseHolder() {
        if (mDatabaseHolder == null) {
            try {
                mDatabaseHolder = (DatabaseHolder)Class.forName("com.grosner.dbflow.config.Database$Holder").newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return mDatabaseHolder;
    }

    public static <ModelClass extends Model> ConditionQueryBuilder<ModelClass> getPrimaryWhereQuery(Class<ModelClass> table) {
        return FlowManager.getDatabaseForTable(table).getModelAdapterForTable(table).getPrimaryModelWhere();
    }

    public static Context getContext() {
        if (context == null) {
            throw new IllegalStateException("Context cannot be null for FlowManager");
        }
        return context;
    }

    public static void init(Context context) {
        FlowManager.context = context;
        FlowManager.getDatabaseHolder();
    }

    public static void setDatabaseListener(String databaseName, DatabaseHelperListener databaseHelperListener) {
        FlowManager.getDatabase(databaseName).setHelperListener(databaseHelperListener);
    }

    public static TypeConverter getTypeConverterForClass(Class<?> modelClass) {
        return mDatabaseHolder.getTypeConverterForClass(modelClass);
    }

    public static synchronized void destroy() {
        context = null;
    }

    public static <ModelClass extends Model> ModelAdapter<ModelClass> getModelAdapter(Class<ModelClass> modelClass) {
        return FlowManager.getDatabaseForTable(modelClass).getModelAdapterForTable(modelClass);
    }

    public static <ModelClass extends Model> ContainerAdapter<ModelClass> getContainerAdapter(Class<ModelClass> modelClass) {
        return FlowManager.getDatabaseForTable(modelClass).getModelContainerAdapterForTable(modelClass);
    }

    public static <ModelViewClass extends BaseModelView<? extends Model>> ModelViewAdapter<? extends Model, ModelViewClass> getModelViewAdapter(Class<ModelViewClass> modelViewClass) {
        return FlowManager.getDatabaseForTable(modelViewClass).getModelViewAdapterForTable(modelViewClass);
    }

    static Map<Integer, List<Migration>> getMigrations(String databaseName) {
        return FlowManager.getDatabase(databaseName).getMigrations();
    }
}

