/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.list;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.grosner.dbflow.list.FlowCursorList;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.BaseTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.runtime.transaction.process.ProcessModel;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelHelper;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelInfo;
import com.grosner.dbflow.sql.SqlUtils;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.language.Delete;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.structure.Model;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FlowTableList<ModelClass extends Model>
extends ContentObserver
implements List<ModelClass> {
    private static DBTransactionInfo MODIFICATION_INFO = DBTransactionInfo.create(BaseTransaction.PRIORITY_HIGH);
    private FlowCursorList<ModelClass> mCursorList;
    private ResultReceiver<List<ModelClass>> mResultReceiver;
    private ResultReceiver<List<ModelClass>> mInternalResultReceiver = new ResultReceiver<List<ModelClass>>(){

        @Override
        public void onResultReceived(List<ModelClass> modelClasses) {
            FlowTableList.this.mCursorList.refresh();
            if (FlowTableList.this.mResultReceiver != null) {
                FlowTableList.this.mResultReceiver.onResultReceived(modelClasses);
            }
        }
    };
    private boolean transact = false;

    public FlowTableList(Class<ModelClass> table) {
        super(null);
        this.mCursorList = new FlowCursorList<ModelClass>(true, table, new Condition[0]);
    }

    public void registerForContentChanges(Context context) {
        context.getContentResolver().registerContentObserver(SqlUtils.getNotificationUri(this.mCursorList.getTable(), null), true, (ContentObserver)this);
    }

    public void unregisterForContentChanges(Context context) {
        context.getContentResolver().unregisterContentObserver((ContentObserver)this);
    }

    public void onChange(boolean selfChange) {
        this.mCursorList.refresh();
    }

    @TargetApi(value=16)
    public void onChange(boolean selfChange, Uri uri) {
        this.mCursorList.refresh();
    }

    public void setModificationReceiver(ResultReceiver<List<ModelClass>> resultReceiver) {
        this.mResultReceiver = resultReceiver;
    }

    public void setTransact(boolean transact) {
        this.transact = transact;
    }

    public List<ModelClass> getCopy() {
        return this.mCursorList.getAll();
    }

    @Override
    public void add(int location, ModelClass model) {
        this.add(model);
    }

    @SafeVarargs
    protected final ProcessModelInfo<ModelClass> getProcessModelInfo(ModelClass ... modelClasses) {
        return ProcessModelInfo.withModels(modelClasses).result(this.mInternalResultReceiver).info(MODIFICATION_INFO);
    }

    protected final ProcessModelInfo<ModelClass> getProcessModelInfo(Collection<ModelClass> modelClasses) {
        return ProcessModelInfo.withModels(modelClasses).result(this.mInternalResultReceiver).info(MODIFICATION_INFO);
    }

    @Override
    public boolean add(ModelClass object) {
        if (this.transact) {
            TransactionManager.getInstance().save(this.getProcessModelInfo(new Model[]{object}));
        } else {
            object.save(false);
            this.mInternalResultReceiver.onResultReceived(Arrays.asList(object));
        }
        return true;
    }

    @Override
    public boolean addAll(int location, Collection<? extends ModelClass> collection) {
        return this.addAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends ModelClass> collection) {
        Collection<? extends ModelClass> tmpCollection = collection;
        if (this.transact) {
            TransactionManager.getInstance().save(this.getProcessModelInfo(tmpCollection));
        } else {
            ProcessModelHelper.process(this.mCursorList.getTable(), tmpCollection, new ProcessModel<ModelClass>(){

                @Override
                public void processModel(ModelClass model) {
                    model.save(false);
                }
            });
            this.mInternalResultReceiver.onResultReceived((List)tmpCollection);
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.transact) {
            TransactionManager.getInstance().delete(MODIFICATION_INFO, this.mCursorList.getTable(), new Condition[0]);
        } else {
            Delete.table(this.mCursorList.getTable(), new Condition[0]);
        }
        this.mInternalResultReceiver.onResultReceived(null);
    }

    @Override
    public boolean contains(Object object) {
        boolean contains = false;
        if (this.mCursorList.getTable().isAssignableFrom(object.getClass())) {
            Model model = (Model)object;
            contains = model.exists();
        }
        return contains;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        boolean contains;
        boolean bl = contains = !collection.isEmpty();
        if (contains) {
            for (Object o : collection) {
                if (this.contains(o)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    @Override
    public ModelClass get(int location) {
        return this.mCursorList.getItem(location);
    }

    @Override
    public int indexOf(Object object) {
        throw new UnsupportedOperationException("We cannot determine which index in the table this item exists at efficiently");
    }

    @Override
    public boolean isEmpty() {
        return this.mCursorList.isEmpty();
    }

    @Override
    @NonNull
    public Iterator<ModelClass> iterator() {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException("We cannot determine which index in the table this item exists at efficiently");
    }

    @Override
    @NonNull
    public ListIterator<ModelClass> listIterator() {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<ModelClass> listIterator(int location) {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.listIterator(location);
    }

    @Override
    public ModelClass remove(int location) {
        ModelClass model = this.mCursorList.getItem(location);
        if (this.transact) {
            TransactionManager.getInstance().delete(this.getProcessModelInfo(new Model[]{model}));
        } else {
            model.delete(false);
            this.mInternalResultReceiver.onResultReceived(Arrays.asList(model));
        }
        return model;
    }

    @Override
    public boolean remove(Object object) {
        boolean removed = false;
        if (this.mCursorList.getTable().isAssignableFrom(object.getClass())) {
            Model model = (Model)object;
            if (this.transact) {
                TransactionManager.getInstance().delete(this.getProcessModelInfo(new Model[]{model}));
            } else {
                model.delete(false);
                this.mInternalResultReceiver.onResultReceived(Arrays.asList(model));
            }
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean removed = false;
        if (this.mCursorList.getTable().isAssignableFrom((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0])) {
            Collection<?> modelCollection = collection;
            if (this.transact) {
                TransactionManager.getInstance().delete(this.getProcessModelInfo(modelCollection));
            } else {
                ProcessModelHelper.process(this.mCursorList.getTable(), modelCollection, new ProcessModel<ModelClass>(){

                    @Override
                    public void processModel(ModelClass model) {
                        model.delete(false);
                    }
                });
                this.mInternalResultReceiver.onResultReceived((List)modelCollection);
            }
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        List<ModelClass> tableList = this.mCursorList.getAll();
        tableList.removeAll(collection);
        if (this.transact) {
            TransactionManager.getInstance().delete(this.getProcessModelInfo((Collection<ModelClass>)tableList));
        } else {
            ProcessModelHelper.process(this.mCursorList.getTable(), tableList, new ProcessModel<ModelClass>(){

                @Override
                public void processModel(ModelClass model) {
                    model.delete(false);
                }
            });
            this.mInternalResultReceiver.onResultReceived(tableList);
        }
        return true;
    }

    @Override
    public ModelClass set(int location, ModelClass object) {
        return this.set(object);
    }

    public ModelClass set(ModelClass object) {
        if (this.transact) {
            TransactionManager.getInstance().update(this.getProcessModelInfo(new Model[]{object}));
        } else {
            object.update(false);
            this.mInternalResultReceiver.onResultReceived(Arrays.asList(object));
        }
        return object;
    }

    @Override
    public int size() {
        return this.mCursorList.getCount();
    }

    @Override
    @NonNull
    public List<ModelClass> subList(int start, int end) {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.subList(start, end);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.toArray();
    }

    @Override
    @NonNull
    public <T> T[] toArray(T[] array) {
        List<ModelClass> tableList = this.mCursorList.getAll();
        return tableList.toArray(array);
    }

    public ModelClass get(Condition ... conditions) {
        return new Select(new String[0]).from(this.mCursorList.getTable()).where(conditions).querySingle();
    }

    public void fetchAll(ResultReceiver<List<ModelClass>> resultReceiver) {
        this.mCursorList.fetchAll(resultReceiver);
    }

    public void removeAll(Condition ... conditions) {
        if (this.transact) {
            TransactionManager.getInstance().delete(this.getProcessModelInfo((Collection<ModelClass>)this.getAll(conditions)));
        } else {
            Delete.table(this.mCursorList.getTable(), conditions);
            this.mInternalResultReceiver.onResultReceived(null);
        }
    }

    public List<ModelClass> getAll(Condition ... conditions) {
        return new Select(new String[0]).from(this.mCursorList.getTable()).where(conditions).queryList();
    }
}

