/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.language;

import android.database.Cursor;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.sql.Queriable;
import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Join;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.sql.language.Set;
import com.grosner.dbflow.sql.language.Update;
import com.grosner.dbflow.sql.language.Where;
import com.grosner.dbflow.sql.language.WhereBase;
import com.grosner.dbflow.structure.Model;
import java.util.ArrayList;
import java.util.List;

public class From<ModelClass extends Model>
implements WhereBase<ModelClass>,
Queriable<ModelClass> {
    private Query mQueryBuilderBase;
    private Class<ModelClass> mTable;
    private String mAlias;
    private List<Join> mJoins = new ArrayList<Join>();

    public From(Query querybase, Class<ModelClass> table) {
        this.mQueryBuilderBase = querybase;
        this.mTable = table;
    }

    public From<ModelClass> as(String alias) {
        this.mAlias = alias;
        return this;
    }

    public <JoinType extends Model> Join<JoinType, ModelClass> join(Class<JoinType> table, Join.JoinType joinType) {
        Join join = new Join(this, table, joinType);
        this.mJoins.add(join);
        return join;
    }

    public Where<ModelClass> where(String whereClause) {
        return this.where().whereClause(whereClause);
    }

    public Where<ModelClass> where() {
        return new Where(this);
    }

    public Where<ModelClass> where(ConditionQueryBuilder<ModelClass> conditionQueryBuilder) {
        return this.where().whereQuery(conditionQueryBuilder);
    }

    public Where<ModelClass> where(Condition ... conditions) {
        return this.where().andThese(conditions);
    }

    @Override
    public Cursor query() {
        return this.where().query();
    }

    @Override
    public List<ModelClass> queryList() {
        return this.where().queryList();
    }

    @Override
    public ModelClass querySingle() {
        return this.where().querySingle();
    }

    public Set<ModelClass> set(Condition ... conditions) {
        return this.set().conditions(conditions);
    }

    public Set<ModelClass> set() {
        if (!(this.mQueryBuilderBase instanceof Update)) {
            throw new IllegalStateException("Cannot use set() without an UPDATE as the base");
        }
        return new Set<ModelClass>(this, this.mTable);
    }

    public Set<ModelClass> set(ConditionQueryBuilder<ModelClass> conditionQueryBuilder) {
        return this.set().conditionQuery(conditionQueryBuilder);
    }

    public String toString() {
        return this.getQuery();
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)this.mQueryBuilderBase.getQuery());
        if (!(this.mQueryBuilderBase instanceof Update)) {
            queryBuilder.append((Object)"FROM ");
        }
        queryBuilder.append((Object)FlowManager.getTableName(this.mTable));
        if (this.mQueryBuilderBase instanceof Select) {
            queryBuilder.appendSpace().appendQualifier("AS", this.mAlias);
            for (Join join : this.mJoins) {
                queryBuilder.append((Object)join.getQuery());
            }
        } else {
            queryBuilder.appendSpace();
        }
        return queryBuilder.getQuery();
    }

    @Override
    public Class<ModelClass> getTable() {
        return this.mTable;
    }

    @Override
    public Query getQueryBuilderBase() {
        return this.mQueryBuilderBase;
    }
}

