/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.migration;

import android.database.sqlite.SQLiteDatabase;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.migration.BaseMigration;
import com.grosner.dbflow.structure.Model;
import java.util.ArrayList;
import java.util.List;

public class AlterTableMigration<ModelClass extends Model>
extends BaseMigration {
    private final Class<ModelClass> mTable;
    private QueryBuilder mQuery;
    private QueryBuilder mRenameQuery;
    private ArrayList<QueryBuilder> mColumnDefinitions;
    private String mOldTableName;

    public AlterTableMigration(Class<ModelClass> table) {
        this.mTable = table;
    }

    @Override
    public void onPreMigrate() {
        this.mQuery = new QueryBuilder().append((Object)"ALTER").appendSpaceSeparated("TABLE");
    }

    @Override
    public void migrate(SQLiteDatabase database) {
        String sql = this.mQuery.getQuery();
        String tableName = FlowManager.getTableName(this.mTable);
        if (this.mRenameQuery != null) {
            database.execSQL(sql + this.mOldTableName + this.mRenameQuery.getQuery() + tableName);
        }
        if (this.mColumnDefinitions != null) {
            sql = sql + tableName;
            for (QueryBuilder columnDefinition : this.mColumnDefinitions) {
                database.execSQL(sql + " ADD COLUMN " + columnDefinition.getQuery());
            }
        }
    }

    @Override
    public void onPostMigrate() {
        this.mQuery = null;
        this.mRenameQuery = null;
        this.mColumnDefinitions = null;
    }

    public AlterTableMigration<ModelClass> renameFrom(String oldName) {
        this.mOldTableName = oldName;
        this.mRenameQuery = new QueryBuilder().append((Object)" RENAME").appendSpaceSeparated("TO");
        return this;
    }

    public AlterTableMigration<ModelClass> addColumn(Class columnType, String columnName) {
        if (this.mColumnDefinitions == null) {
            this.mColumnDefinitions = new ArrayList();
        }
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)columnName).appendSpace().appendType(columnType.getName());
        this.mColumnDefinitions.add(queryBuilder);
        return this;
    }

    public String getRenameQuery() {
        QueryBuilder queryBuilder = new QueryBuilder(this.mQuery.getQuery()).append((Object)this.mOldTableName).append((Object)this.mRenameQuery).append((Object)FlowManager.getTableName(this.mTable));
        return queryBuilder.getQuery();
    }

    public List<String> getColumnDefinitions() {
        String sql = this.mQuery.getQuery() + FlowManager.getTableName(this.mTable);
        ArrayList<String> columnDefinitions = new ArrayList<String>();
        if (this.mColumnDefinitions != null) {
            for (QueryBuilder columnDefinition : this.mColumnDefinitions) {
                QueryBuilder queryBuilder = new QueryBuilder(sql).appendSpaceSeparated("ADD COLUMN").append((Object)columnDefinition.getQuery());
                columnDefinitions.add(queryBuilder.getQuery());
            }
        }
        return columnDefinitions;
    }
}

