/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.migration;

import android.database.sqlite.SQLiteDatabase;
import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Update;
import com.grosner.dbflow.sql.migration.BaseMigration;
import com.grosner.dbflow.structure.Model;

public class UpdateTableMigration<ModelClass extends Model>
extends BaseMigration
implements Query {
    private final Class<ModelClass> mTable;
    private QueryBuilder mQuery;
    private ConditionQueryBuilder<ModelClass> mWhereConditionQueryBuilder;
    private ConditionQueryBuilder<ModelClass> mSetConditionQueryBuilder;

    public UpdateTableMigration(Class<ModelClass> table) {
        this.mTable = table;
    }

    public UpdateTableMigration<ModelClass> set(Condition ... conditions) {
        if (this.mSetConditionQueryBuilder == null) {
            this.mSetConditionQueryBuilder = new ConditionQueryBuilder<ModelClass>(this.mTable, new Condition[0]);
        }
        this.mSetConditionQueryBuilder.putConditions(conditions);
        return this;
    }

    public UpdateTableMigration<ModelClass> where(Condition ... conditions) {
        if (this.mWhereConditionQueryBuilder == null) {
            this.mWhereConditionQueryBuilder = new ConditionQueryBuilder<ModelClass>(this.mTable, new Condition[0]);
        }
        this.mWhereConditionQueryBuilder.putConditions(conditions);
        return this;
    }

    @Override
    public void onPreMigrate() {
        this.mQuery = new QueryBuilder(new Update().table(this.mTable).set(this.mSetConditionQueryBuilder).where(this.mWhereConditionQueryBuilder).getQuery());
    }

    @Override
    public void migrate(SQLiteDatabase database) {
        database.execSQL(this.mQuery.getQuery());
    }

    @Override
    public void onPostMigrate() {
        this.mQuery = null;
        this.mSetConditionQueryBuilder = null;
    }

    public String getQuery() {
        return this.mQuery.getQuery();
    }
}

