/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.structure;

import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.structure.Model;

public abstract class BaseModelView<ModelClass extends Model>
implements Model {
    @Override
    public void save(boolean async) {
        throw new InvalidSqlViewOperationException("View " + this.getClass().getName() + " is not saveable");
    }

    @Override
    public void delete(boolean async) {
        throw new InvalidSqlViewOperationException("View " + this.getClass().getName() + " is not deleteable");
    }

    @Override
    public void update(boolean async) {
        throw new InvalidSqlViewOperationException("View " + this.getClass().getName() + " is not updateable");
    }

    @Override
    public void insert(boolean async) {
        throw new InvalidSqlViewOperationException("View " + this.getClass().getName() + " is not insertable");
    }

    @Override
    public boolean exists() {
        return FlowManager.getModelViewAdapter(this.getClass()).exists(this);
    }

    private static class InvalidSqlViewOperationException
    extends RuntimeException {
        private InvalidSqlViewOperationException(String detailMessage) {
            super(detailMessage);
        }
    }
}

