/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.structure.container;

import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.structure.InvalidDBConfiguration;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import com.grosner.dbflow.structure.container.ContainerAdapter;
import com.grosner.dbflow.structure.container.ModelContainer;

public abstract class BaseModelContainer<ModelClass extends Model, DataClass>
implements ModelContainer<ModelClass, DataClass>,
Model {
    ModelClass mModel;
    ModelAdapter<ModelClass> mModelAdapter;
    ContainerAdapter<ModelClass> mContainerAdapter;
    DataClass mData;

    public BaseModelContainer(Class<ModelClass> table) {
        this.mModelAdapter = FlowManager.getModelAdapter(table);
    }

    public BaseModelContainer(Class<ModelClass> table, DataClass data) {
        this.mModelAdapter = FlowManager.getModelAdapter(table);
        this.mContainerAdapter = FlowManager.getContainerAdapter(table);
        this.mData = data;
        if (this.mContainerAdapter == null) {
            throw new InvalidDBConfiguration("The table" + FlowManager.getTableName(table) + " did not specify the ContainerAdapter" + "annotation. Please add and rebuild");
        }
    }

    @Override
    public ModelClass toModel() {
        if (this.mModel == null) {
            this.mModel = this.mContainerAdapter.toModel(this);
        }
        return this.mModel;
    }

    @Override
    public abstract BaseModelContainer getInstance(Object var1, Class<? extends Model> var2);

    protected Object getModelValue(Object inValue, String columnName) {
        ContainerAdapter<ModelClass> containerAdapter = FlowManager.getContainerAdapter(this.getTable());
        Class<?> columnClass = containerAdapter.getClassForColumn(columnName);
        ContainerAdapter<?> columnAdapter = FlowManager.getContainerAdapter(columnClass);
        if (columnAdapter == null) {
            throw new RuntimeException("Column: " + columnName + "'s class needs to add the @ContainerAdapter annotation");
        }
        inValue = columnAdapter.toModel(this.getInstance(inValue, columnClass));
        return inValue;
    }

    @Override
    public DataClass getData() {
        return this.mData;
    }

    public void setData(DataClass data) {
        this.mData = data;
    }

    @Override
    public abstract Object getValue(String var1);

    @Override
    public abstract void put(String var1, Object var2);

    @Override
    public ModelAdapter<ModelClass> getModelAdapter() {
        return this.mModelAdapter;
    }

    @Override
    public Class<ModelClass> getTable() {
        return this.mModelAdapter.getModelClass();
    }

    @Override
    public void save(boolean async) {
        this.mContainerAdapter.save(async, this, 0);
    }

    @Override
    public void delete(boolean async) {
        this.mContainerAdapter.delete(async, this);
    }

    @Override
    public void update(boolean async) {
        this.mContainerAdapter.save(async, this, 1);
    }

    @Override
    public void insert(boolean async) {
        this.mContainerAdapter.save(async, this, 2);
    }

    @Override
    public boolean exists() {
        return this.mContainerAdapter.exists(this);
    }
}

