/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.structure.container;

import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.container.BaseModelContainer;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONModel<ModelClass extends Model>
extends BaseModelContainer<ModelClass, JSONObject>
implements Model {
    public JSONModel(JSONObject jsonObject, Class<ModelClass> table) {
        super(table, jsonObject);
    }

    public JSONModel(Class<ModelClass> table) {
        super(table, new JSONObject());
    }

    @Override
    public BaseModelContainer getInstance(Object inValue, Class<? extends Model> columnClass) {
        return new JSONModel<Model>((JSONObject)inValue, columnClass);
    }

    @Override
    public JSONObject newDataInstance() {
        return new JSONObject();
    }

    @Override
    public Object getValue(String columnName) {
        return ((JSONObject)this.getData()).opt(columnName);
    }

    @Override
    public void put(String columnName, Object value) {
        try {
            ((JSONObject)this.getData()).put(columnName, value);
        }
        catch (JSONException e) {
            FlowLog.logError(e);
        }
    }

    public void load(Object ... primaryKeys) {
        this.setData(new JSONObject());
        ConditionQueryBuilder primaryQuery = FlowManager.getPrimaryWhereQuery(this.getTable());
        this.load(new Select(new String[0]).from(this.mModelAdapter.getModelClass()).where(primaryQuery.replaceEmptyParams(primaryKeys)).query());
    }
}

