/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.structure.container;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import com.grosner.dbflow.config.BaseDatabaseDefinition;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelInfo;
import com.grosner.dbflow.sql.SqlUtils;
import com.grosner.dbflow.sql.language.Delete;
import com.grosner.dbflow.structure.BaseModel;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import com.grosner.dbflow.structure.container.ContainerAdapter;
import com.grosner.dbflow.structure.container.ModelContainer;

public class ModelContainerUtils {
    public static <ModelClass extends Model> void sync(boolean async, ModelContainer<ModelClass, ?> modelContainer, ContentValues contentValues, @SqlUtils.SaveMode int mode) {
        if (!async) {
            long id;
            BaseDatabaseDefinition flowManager = FlowManager.getDatabaseForTable(modelContainer.getTable());
            ContainerAdapter containerAdapter = flowManager.getModelContainerAdapterForTable(modelContainer.getTable());
            ModelAdapter<ModelClass> modelAdapter = modelContainer.getModelAdapter();
            SQLiteDatabase db = flowManager.getWritableDatabase();
            boolean exists = false;
            BaseModel.Action action = BaseModel.Action.SAVE;
            if (mode == 0) {
                exists = containerAdapter.exists(modelContainer);
            } else if (mode == 1) {
                exists = true;
                action = BaseModel.Action.UPDATE;
            } else {
                action = BaseModel.Action.INSERT;
            }
            if (exists) {
                boolean bl = exists = db.update(modelAdapter.getTableName(), contentValues, containerAdapter.getPrimaryModelWhere(modelContainer).getQuery(), null) != 0;
            }
            if (exists || (id = db.insert(modelAdapter.getTableName(), null, contentValues)) != 0L) {
                // empty if block
            }
            SqlUtils.notifyModelChanged(modelContainer.getTable(), action);
        } else {
            TransactionManager.getInstance().save(ProcessModelInfo.withModels((Model[])new ModelContainer[]{modelContainer}));
        }
    }

    public static <ModelClass extends Model> void delete(ModelContainer<ModelClass, ?> modelContainer, ContainerAdapter<ModelClass> containerAdapter, boolean async) {
        if (!async) {
            new Delete().from(modelContainer.getTable()).where(containerAdapter.getPrimaryModelWhere(modelContainer)).query();
            SqlUtils.notifyModelChanged(modelContainer.getTable(), BaseModel.Action.DELETE);
        } else {
            TransactionManager.getInstance().delete(ProcessModelInfo.withModels((Model[])new ModelContainer[]{modelContainer}));
        }
    }
}

