/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql;

import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.SQLiteType;
import java.util.List;

public class QueryBuilder<QueryClass extends QueryBuilder>
implements Query {
    protected StringBuilder mQuery = new StringBuilder();

    public QueryBuilder() {
    }

    public QueryBuilder(String string) {
        this.mQuery.append(string);
    }

    public QueryClass appendSpace() {
        return this.append(" ");
    }

    public QueryClass appendSpaceSeparated(String string) {
        return ((QueryBuilder)((QueryBuilder)this.appendSpace()).append(string)).appendSpace();
    }

    public QueryClass appendParenthesisEnclosed(String string) {
        return ((QueryBuilder)((QueryBuilder)this.append("(")).append(string)).append(")");
    }

    public QueryClass append(Object object) {
        this.mQuery.append(object);
        return this.castThis();
    }

    protected QueryClass castThis() {
        return (QueryClass)this;
    }

    public QueryClass appendType(String type) {
        return this.appendSQLiteType(SQLiteType.get(type));
    }

    public QueryClass appendSQLiteType(SQLiteType sqLiteType) {
        return this.append(sqLiteType.name());
    }

    public QueryClass appendArray(Object ... objects) {
        return this.append(QueryBuilder.join((CharSequence)", ", objects));
    }

    public QueryClass appendList(List<?> objects) {
        return this.append(QueryBuilder.join((CharSequence)", ", objects));
    }

    public QueryClass appendQualifier(String name, String value) {
        if (value != null && !value.isEmpty()) {
            ((QueryBuilder)this.append(name)).appendSpaceSeparated(value);
        }
        return this.castThis();
    }

    public QueryClass appendNotEmpty(String string) {
        if (string != null && !string.isEmpty()) {
            this.append(string);
        }
        return this.castThis();
    }

    public String toString() {
        return this.getQuery();
    }

    @Override
    public String getQuery() {
        return this.mQuery.toString();
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }
}

