/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql;

import java.util.HashMap;

public enum SQLiteType {
    INTEGER,
    REAL,
    TEXT,
    BLOB;

    private static final HashMap<String, SQLiteType> sTypeMap;

    public static SQLiteType get(String className) {
        return sTypeMap.get(className);
    }

    public static boolean containsClass(String className) {
        return sTypeMap.containsKey(className);
    }

    static {
        sTypeMap = new HashMap<String, SQLiteType>(){
            {
                this.put(Byte.TYPE.getName(), INTEGER);
                this.put(Short.TYPE.getName(), INTEGER);
                this.put(Integer.TYPE.getName(), INTEGER);
                this.put(Long.TYPE.getName(), INTEGER);
                this.put(Float.TYPE.getName(), REAL);
                this.put(Double.TYPE.getName(), REAL);
                this.put(Boolean.TYPE.getName(), INTEGER);
                this.put(Character.TYPE.getName(), TEXT);
                this.put(byte[].class.getName(), BLOB);
                this.put(Byte.class.getName(), INTEGER);
                this.put(Short.class.getName(), INTEGER);
                this.put(Integer.class.getName(), INTEGER);
                this.put(Long.class.getName(), INTEGER);
                this.put(Float.class.getName(), REAL);
                this.put(Double.class.getName(), REAL);
                this.put(Boolean.class.getName(), INTEGER);
                this.put(Character.class.getName(), TEXT);
                this.put(String.class.getName(), TEXT);
                this.put(Byte[].class.getName(), BLOB);
            }
        };
    }
}

