/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.config;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import com.grosner.dbflow.DatabaseHelperListener;
import com.grosner.dbflow.config.BaseDatabaseDefinition;
import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.config.NaturalOrderComparator;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.migration.Migration;
import com.grosner.dbflow.structure.ModelAdapter;
import com.grosner.dbflow.structure.ModelViewAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FlowSQLiteOpenHelper
extends SQLiteOpenHelper {
    public static final String MIGRATION_PATH = "migrations";
    private DatabaseHelperListener mListener;
    private BaseDatabaseDefinition mManager;

    public FlowSQLiteOpenHelper(BaseDatabaseDefinition flowManager, DatabaseHelperListener listener) {
        super(FlowManager.getContext(), flowManager.getDatabaseName() + ".db", null, flowManager.getDatabaseVersion());
        this.mListener = listener;
        this.mManager = flowManager;
        boolean forceMove = false;
        if (flowManager.areConsistencyChecksEnabled()) {
            forceMove = Build.VERSION.SDK_INT >= 11 ? !this.getWritableDatabase().isDatabaseIntegrityOk() : !this.isDatabaseIntegrityOk();
        }
        this.movePrepackagedDB(flowManager.getDatabaseName() + ".db", forceMove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseIntegrityOk() {
        try (SQLiteStatement prog = null;){
            prog = this.getWritableDatabase().compileStatement("PRAGMA integrity_check;");
            String rslt = prog.simpleQueryForString();
            if (!rslt.equalsIgnoreCase("ok")) {
                FlowLog.log(FlowLog.Level.E, "PRAGMA integrity_check on " + this.mManager.getDatabaseName() + " returned: " + rslt);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public void movePrepackagedDB(String databaseName, boolean forceMove) {
        File dbPath = FlowManager.getContext().getDatabasePath(databaseName);
        if (!forceMove && dbPath.exists()) {
            return;
        }
        if (forceMove) {
            dbPath.delete();
        }
        dbPath.getParentFile().mkdirs();
        try {
            int length;
            InputStream inputStream = FlowManager.getContext().getAssets().open(databaseName);
            FileOutputStream output = new FileOutputStream(dbPath);
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
            output.flush();
            ((OutputStream)output).close();
            inputStream.close();
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.E, "Failed to open file", e);
        }
    }

    public void setDatabaseListener(DatabaseHelperListener mListener) {
        this.mListener = mListener;
    }

    public void onCreate(SQLiteDatabase db) {
        if (this.mListener != null) {
            this.mListener.onCreate(db);
        }
        this.checkForeignKeySupport(db);
        this.executeCreations(db);
        this.executeMigrations(db, -1, db.getVersion());
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (this.mListener != null) {
            this.mListener.onUpgrade(db, oldVersion, newVersion);
        }
        this.checkForeignKeySupport(db);
        this.executeCreations(db);
        this.executeMigrations(db, oldVersion, newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
        if (this.mListener != null) {
            this.mListener.onOpen(db);
        }
        this.checkForeignKeySupport(db);
    }

    private void checkForeignKeySupport(SQLiteDatabase database) {
        if (this.mManager.isForeignKeysSupported()) {
            database.execSQL("PRAGMA foreign_keys=ON;");
            FlowLog.log(FlowLog.Level.I, "Foreign Keys supported. Enabling foreign key features.");
        }
    }

    private void executeCreations(final SQLiteDatabase database) {
        TransactionManager.transact(database, new Runnable(){

            @Override
            public void run() {
                List<ModelAdapter> modelAdapters = FlowSQLiteOpenHelper.this.mManager.getModelAdapters();
                for (ModelAdapter modelAdapter : modelAdapters) {
                    database.execSQL(modelAdapter.getCreationQuery());
                }
                List<ModelViewAdapter> modelViews = FlowSQLiteOpenHelper.this.mManager.getModelViewAdapters();
                for (ModelViewAdapter modelView : modelViews) {
                    QueryBuilder queryBuilder = new QueryBuilder().append((Object)"CREATE VIEW").appendSpaceSeparated(modelView.getViewName()).append((Object)"AS ").append((Object)modelView.getCreationQuery());
                    try {
                        database.execSQL(queryBuilder.getQuery());
                    }
                    catch (SQLiteException e) {
                        FlowLog.logError(e);
                    }
                }
            }
        });
    }

    private void executeMigrations(final SQLiteDatabase db, final int oldVersion, final int newVersion) {
        try {
            final List<String> files = Arrays.asList(FlowManager.getContext().getAssets().list(MIGRATION_PATH));
            Collections.sort(files, new NaturalOrderComparator());
            TransactionManager.transact(db, new Runnable(){

                @Override
                public void run() {
                    for (String file : files) {
                        try {
                            int version = Integer.valueOf(file.replace(".sql", ""));
                            if (version <= oldVersion || version > newVersion) continue;
                            FlowSQLiteOpenHelper.this.executeSqlScript(db, file);
                            FlowLog.log(FlowLog.Level.I, file + " executed succesfully.");
                        }
                        catch (NumberFormatException e) {
                            FlowLog.log(FlowLog.Level.W, "Skipping invalidly named file: " + file, e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.E, "Failed to execute migrations.", e);
        }
        Map<Integer, List<Migration>> migrationMap = this.mManager.getMigrations();
        if (migrationMap != null) {
            int curVersion;
            for (int i = curVersion = oldVersion + 1; i <= newVersion; ++i) {
                List<Migration> migrationsList = migrationMap.get(i);
                if (migrationsList == null) continue;
                for (Migration migration : migrationsList) {
                    migration.onPreMigrate();
                    migration.migrate(db);
                    migration.onPostMigrate();
                }
            }
        }
    }

    private void executeSqlScript(SQLiteDatabase db, String file) {
        try {
            String line;
            InputStream input = FlowManager.getContext().getAssets().open("migrations/" + file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                db.execSQL(line.replace(";", ""));
            }
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.E, "Failed to execute " + file, e);
        }
    }
}

