/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.list;

import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.util.SparseArray;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.BaseResultTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.sql.SqlUtils;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.sql.language.Where;
import com.grosner.dbflow.structure.Model;
import java.util.List;

public class FlowCursorList<ModelClass extends Model> {
    private Cursor mCursor;
    private Class<ModelClass> mTable;
    private SparseArray<ModelClass> mModelCache;
    private boolean cacheModels;
    private Where<ModelClass> mWhere;

    public FlowCursorList(boolean cacheModels, Class<ModelClass> table, Condition ... conditions) {
        this.cacheModels = cacheModels;
        this.mWhere = new Select(new String[0]).from(table).where(conditions);
        this.mCursor = this.mWhere.query();
        this.mTable = table;
        if (cacheModels) {
            this.mModelCache = new SparseArray(this.mCursor.getCount());
        }
        this.mCursor.registerContentObserver((ContentObserver)new CursorObserver());
    }

    public void refresh() {
        this.mCursor.close();
        this.mCursor = this.mWhere.query();
        if (this.cacheModels) {
            this.mModelCache.clear();
        }
    }

    public ModelClass getItem(int position) {
        Model model;
        if (this.cacheModels) {
            model = (Model)this.mModelCache.get(position);
            if (model == null && this.mCursor.moveToPosition(position)) {
                model = SqlUtils.convertToModel(false, this.mTable, this.mCursor);
                this.mModelCache.put(position, (Object)model);
            }
        } else {
            this.mCursor.moveToPosition(position);
            model = SqlUtils.convertToModel(false, this.mTable, this.mCursor);
        }
        return (ModelClass)model;
    }

    public void fetchAll(ResultReceiver<List<ModelClass>> resultReceiver) {
        TransactionManager.getInstance().addTransaction(new BaseResultTransaction<List<ModelClass>>(DBTransactionInfo.createFetch(), resultReceiver){

            @Override
            public List<ModelClass> onExecute() {
                return FlowCursorList.this.getAll();
            }
        });
    }

    public List<ModelClass> getAll() {
        return SqlUtils.convertToList(this.mTable, this.mCursor);
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public int getCount() {
        return this.mCursor != null ? this.mCursor.getCount() : 0;
    }

    public void close() {
        this.mCursor.close();
    }

    public Class<ModelClass> getTable() {
        return this.mTable;
    }

    class CursorObserver
    extends ContentObserver {
        CursorObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            if (FlowCursorList.this.mCursor != null && !FlowCursorList.this.mCursor.isClosed()) {
                FlowCursorList.this.refresh();
            }
        }
    }
}

