/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime;

import android.os.Looper;
import android.os.Process;
import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelInfo;
import com.grosner.dbflow.structure.Model;
import java.util.ArrayList;
import java.util.Collection;

public class DBBatchSaveQueue
extends Thread {
    private static final int sMODEL_SAVE_SIZE = 50;
    private int mModelSaveSize = 50;
    private static final int sMODEL_SAVE_CHECK_TIME = 30000;
    private long mModelSaveCheckTime = 30000L;
    private static DBBatchSaveQueue mBatchSaveQueue;
    private final ArrayList<Model> mModels = new ArrayList();
    private boolean mQuit = false;

    private DBBatchSaveQueue() {
        super("DBBatchSaveQueue");
    }

    public static DBBatchSaveQueue getSharedSaveQueue() {
        if (mBatchSaveQueue == null) {
            mBatchSaveQueue = new DBBatchSaveQueue();
        }
        return mBatchSaveQueue;
    }

    public static void disposeSharedQueue() {
        mBatchSaveQueue = null;
    }

    public void setModelSaveSize(int mModelSaveSize) {
        this.mModelSaveSize = mModelSaveSize;
    }

    public void setModelSaveCheckTime(long time) {
        this.mModelSaveCheckTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.run();
        Looper.prepare();
        Process.setThreadPriority((int)10);
        do {
            ArrayList<Model> tmpModels;
            ArrayList<Model> arrayList = this.mModels;
            synchronized (arrayList) {
                tmpModels = new ArrayList<Model>(this.mModels);
                this.mModels.clear();
            }
            if (tmpModels.size() > 0) {
                TransactionManager.getInstance().save(ProcessModelInfo.withModels(tmpModels).info(DBTransactionInfo.create("Batch Saving Models")));
            }
            try {
                Thread.sleep(this.mModelSaveCheckTime);
            }
            catch (InterruptedException e) {
                FlowLog.log(FlowLog.Level.I, "DBRequestQueue Batch interrupted to start saving");
            }
        } while (!this.mQuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Model inModel) {
        ArrayList<Model> arrayList = this.mModels;
        synchronized (arrayList) {
            this.mModels.add(inModel);
            if (this.mModels.size() > this.mModelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ModelClass extends Model> void addAll(Collection<ModelClass> list) {
        ArrayList<Model> arrayList = this.mModels;
        synchronized (arrayList) {
            this.mModels.addAll(list);
            if (this.mModels.size() > this.mModelSaveSize) {
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Model outModel) {
        ArrayList<Model> arrayList = this.mModels;
        synchronized (arrayList) {
            this.mModels.remove(outModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection<? extends Model> outCollection) {
        ArrayList<Model> arrayList = this.mModels;
        synchronized (arrayList) {
            this.mModels.removeAll(outCollection);
        }
    }

    public void quit() {
        this.mQuit = true;
    }
}

