/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime;

import com.grosner.dbflow.runtime.transaction.BaseTransaction;
import java.util.UUID;

public class DBTransactionInfo {
    private String name;
    private int priority;

    private DBTransactionInfo() {
    }

    public static DBTransactionInfo create(String name) {
        return DBTransactionInfo.create(name, BaseTransaction.PRIORITY_NORMAL);
    }

    public static DBTransactionInfo create(String name, int priority) {
        DBTransactionInfo requestInfo = new DBTransactionInfo();
        requestInfo.name = name;
        requestInfo.priority = priority;
        return requestInfo;
    }

    public static DBTransactionInfo create(int priority) {
        DBTransactionInfo requestInfo = new DBTransactionInfo();
        requestInfo.name = UUID.randomUUID().toString();
        requestInfo.priority = priority;
        return requestInfo;
    }

    public static DBTransactionInfo create() {
        DBTransactionInfo requestInfo = new DBTransactionInfo();
        requestInfo.name = UUID.randomUUID().toString();
        requestInfo.priority = BaseTransaction.PRIORITY_LOW;
        return requestInfo;
    }

    public static DBTransactionInfo createFetch() {
        DBTransactionInfo requestInfo = new DBTransactionInfo();
        requestInfo.priority = BaseTransaction.PRIORITY_UI;
        requestInfo.name = "fetch " + UUID.randomUUID().toString();
        return requestInfo;
    }

    public static DBTransactionInfo createSave() {
        DBTransactionInfo requestInfo = new DBTransactionInfo();
        requestInfo.priority = BaseTransaction.PRIORITY_NORMAL;
        requestInfo.name = "save " + UUID.randomUUID().toString();
        return requestInfo;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }
}

