/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime;

import android.os.Looper;
import android.os.Process;
import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.BaseTransaction;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;

public class DBTransactionQueue
extends Thread {
    private final PriorityBlockingQueue<BaseTransaction> mQueue = new PriorityBlockingQueue();
    private boolean mQuit = false;

    public DBTransactionQueue(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Process.setThreadPriority((int)10);
        while (true) {
            BaseTransaction transaction;
            try {
                transaction = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                PriorityBlockingQueue<BaseTransaction> priorityBlockingQueue = this.mQueue;
                synchronized (priorityBlockingQueue) {
                    this.mQueue.clear();
                }
                return;
            }
            try {
                if (!transaction.onReady()) continue;
                if (FlowLog.isEnabled(FlowLog.Level.I)) {
                    FlowLog.log(FlowLog.Level.I, "Size is " + this.mQueue.size() + " executing " + transaction.getName());
                }
                final Object result = transaction.onExecute();
                final BaseTransaction finalTransaction = transaction;
                if (!transaction.hasResult(result)) continue;
                TransactionManager.getInstance().processOnRequestHandler(new Runnable(){

                    @Override
                    public void run() {
                        finalTransaction.onPostExecute(result);
                    }
                });
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public void add(BaseTransaction runnable) {
        if (!this.mQueue.contains(runnable)) {
            this.mQueue.add(runnable);
        }
    }

    public void cancel(BaseTransaction runnable) {
        if (this.mQueue.contains(runnable)) {
            this.mQueue.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String tag) {
        PriorityBlockingQueue<BaseTransaction> priorityBlockingQueue = this.mQueue;
        synchronized (priorityBlockingQueue) {
            Iterator<BaseTransaction> it = this.mQueue.iterator();
            while (it.hasNext()) {
                BaseTransaction next = it.next();
                if (!next.getName().equals(tag)) continue;
                it.remove();
            }
        }
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }
}

