/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import com.grosner.dbflow.sql.SqlUtils;
import com.grosner.dbflow.structure.BaseModel;
import com.grosner.dbflow.structure.Model;
import java.util.ArrayList;
import java.util.List;

public class FlowContentObserver
extends ContentObserver {
    private List<ModelChangeListener> mModelChangeListeners = new ArrayList<ModelChangeListener>();

    public FlowContentObserver() {
        super(null);
    }

    public void addModelChangeListener(ModelChangeListener modelChangeListener) {
        this.mModelChangeListeners.add(modelChangeListener);
    }

    public void removeModelChangeListener(ModelChangeListener modelChangeListener) {
        this.mModelChangeListeners.remove(modelChangeListener);
    }

    public void registerForContentChanges(Context context, Class<? extends Model> table) {
        context.getContentResolver().registerContentObserver(SqlUtils.getNotificationUri(table, null), true, (ContentObserver)this);
    }

    public void unregisterForContentChanges(Context context) {
        context.getContentResolver().unregisterContentObserver((ContentObserver)this);
    }

    public void onChange(boolean selfChange) {
        for (ModelChangeListener modelChangeListener : this.mModelChangeListeners) {
            modelChangeListener.onModelChanged();
        }
    }

    @TargetApi(value=16)
    public void onChange(boolean selfChange, Uri uri) {
        String fragment = uri.getFragment();
        BaseModel.Action action = BaseModel.Action.valueOf(fragment);
        if (action != null) {
            for (ModelChangeListener modelChangeListener : this.mModelChangeListeners) {
                if (action.equals((Object)BaseModel.Action.DELETE)) {
                    modelChangeListener.onModelDeleted();
                    continue;
                }
                if (action.equals((Object)BaseModel.Action.INSERT)) {
                    modelChangeListener.onModelInserted();
                    continue;
                }
                if (action.equals((Object)BaseModel.Action.UPDATE)) {
                    modelChangeListener.onModelUpdated();
                    continue;
                }
                if (!action.equals((Object)BaseModel.Action.SAVE)) continue;
                modelChangeListener.onModelSaved();
            }
        }
    }

    public static interface ModelChangeListener {
        public void onModelChanged();

        @TargetApi(value=17)
        public void onModelSaved();

        @TargetApi(value=17)
        public void onModelDeleted();

        @TargetApi(value=17)
        public void onModelInserted();

        @TargetApi(value=17)
        public void onModelUpdated();
    }
}

