/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Looper;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.runtime.DBBatchSaveQueue;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.DBTransactionQueue;
import com.grosner.dbflow.runtime.TransactionManagerRuntime;
import com.grosner.dbflow.runtime.transaction.BaseTransaction;
import com.grosner.dbflow.runtime.transaction.DeleteTransaction;
import com.grosner.dbflow.runtime.transaction.QueryTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.runtime.transaction.SelectListTransaction;
import com.grosner.dbflow.runtime.transaction.SelectSingleModelTransaction;
import com.grosner.dbflow.runtime.transaction.UpdateTransaction;
import com.grosner.dbflow.runtime.transaction.process.DeleteModelListTransaction;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelInfo;
import com.grosner.dbflow.runtime.transaction.process.SaveModelTransaction;
import com.grosner.dbflow.runtime.transaction.process.UpdateModelListTransaction;
import com.grosner.dbflow.sql.Queriable;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Where;
import com.grosner.dbflow.structure.Model;
import java.util.Collection;
import java.util.List;

public class TransactionManager {
    private static TransactionManager manager;
    private final boolean hasOwnQueue;
    protected Handler mRequestHandler = new Handler(Looper.getMainLooper());
    private DBTransactionQueue mQueue;
    private String mName;

    public TransactionManager(String name, boolean createNewQueue) {
        this.mName = name;
        this.hasOwnQueue = createNewQueue;
        TransactionManagerRuntime.getManagers().add(this);
        this.checkQueue();
    }

    void checkQueue() {
        if (!this.getQueue().isAlive()) {
            this.getQueue().start();
        }
    }

    DBTransactionQueue getQueue() {
        if (this.mQueue == null) {
            this.mQueue = this.hasOwnQueue ? new DBTransactionQueue(this.mName) : TransactionManager.getInstance().mQueue;
        }
        return this.mQueue;
    }

    public static TransactionManager getInstance() {
        if (manager == null) {
            manager = new TransactionManager(TransactionManager.class.getSimpleName(), true);
        }
        return manager;
    }

    public static void transact(String databaseName, Runnable runnable) {
        TransactionManager.transact(FlowManager.getDatabase(databaseName).getWritableDatabase(), runnable);
    }

    public static void transact(SQLiteDatabase database, Runnable runnable) {
        database.beginTransaction();
        try {
            runnable.run();
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    public boolean hasOwnQueue() {
        return this.hasOwnQueue;
    }

    void disposeQueue() {
        this.mQueue = null;
    }

    public synchronized void processOnRequestHandler(Runnable runnable) {
        this.mRequestHandler.post(runnable);
    }

    public synchronized void processOnRequestHandler(long delay, Runnable runnable) {
        this.mRequestHandler.postDelayed(runnable, delay);
    }

    public <ModelClass extends Model> void transactQuery(DBTransactionInfo transactionInfo, Queriable<ModelClass> queriable) {
        this.transactQuery(transactionInfo, queriable, null);
    }

    public <ModelClass extends Model> void transactQuery(DBTransactionInfo transactionInfo, Queriable<ModelClass> queriable, ResultReceiver<Cursor> cursorResultReceiver) {
        this.addTransaction(new QueryTransaction<ModelClass>(transactionInfo, queriable, cursorResultReceiver));
    }

    public void addTransaction(BaseTransaction transaction) {
        this.getQueue().add(transaction);
    }

    public <ModelClass extends Model> void fetchFromTable(ResultReceiver<List<ModelClass>> resultReceiver, ConditionQueryBuilder<ModelClass> whereConditionQueryBuilder, String ... columns) {
        this.addTransaction(new SelectListTransaction<ModelClass>(resultReceiver, whereConditionQueryBuilder, columns));
    }

    public <ModelClass extends Model> void fetchFromTable(Class<ModelClass> tableClass, ResultReceiver<List<ModelClass>> resultReceiver, Condition ... conditions) {
        this.addTransaction(new SelectListTransaction<ModelClass>(resultReceiver, tableClass, conditions));
    }

    public <ModelClass extends Model> void fetchFromTable(ConditionQueryBuilder<ModelClass> conditionQueryBuilder, ResultReceiver<List<ModelClass>> resultReceiver) {
        this.fetchFromTable(Where.with(conditionQueryBuilder, new String[0]), resultReceiver);
    }

    public <ModelClass extends Model> void fetchFromTable(Where<ModelClass> where, ResultReceiver<List<ModelClass>> resultReceiver) {
        this.addTransaction(new SelectListTransaction<ModelClass>(where, resultReceiver));
    }

    public <ModelClass extends Model> void fetchModelById(Class<ModelClass> tableClass, ResultReceiver<ModelClass> resultReceiver, Object ... ids) {
        ConditionQueryBuilder<ModelClass> queryBuilder = FlowManager.getPrimaryWhereQuery(tableClass);
        this.fetchModel(queryBuilder.replaceEmptyParams(ids), resultReceiver);
    }

    public <ModelClass extends Model> void fetchModel(ConditionQueryBuilder<ModelClass> conditionQueryBuilder, ResultReceiver<ModelClass> resultReceiver) {
        this.fetchModel(Where.with(conditionQueryBuilder, new String[0]), resultReceiver);
    }

    public <ModelClass extends Model> void fetchModel(Where<ModelClass> where, ResultReceiver<ModelClass> resultReceiver) {
        this.addTransaction(new SelectSingleModelTransaction<ModelClass>(where, resultReceiver));
    }

    public <ModelClass extends Model> void saveOnSaveQueue(ModelClass model) {
        if (!this.getSaveQueue().isAlive()) {
            this.getSaveQueue().start();
        }
        this.getSaveQueue().add(model);
    }

    public DBBatchSaveQueue getSaveQueue() {
        return DBBatchSaveQueue.getSharedSaveQueue();
    }

    public <ModelClass extends Model> void saveOnSaveQueue(Collection<ModelClass> models) {
        if (!this.getSaveQueue().isAlive()) {
            this.getSaveQueue().start();
        }
        this.getSaveQueue().addAll(models);
    }

    public <ModelClass extends Model> void save(ProcessModelInfo<ModelClass> modelInfo) {
        this.addTransaction(new SaveModelTransaction<ModelClass>(modelInfo));
    }

    public <ModelClass extends Model> void delete(ProcessModelInfo<ModelClass> modelInfo) {
        this.addTransaction(new DeleteModelListTransaction<ModelClass>(modelInfo));
    }

    public <ModelClass extends Model> void delete(DBTransactionInfo transactionInfo, Class<ModelClass> table, Condition ... conditions) {
        this.addTransaction(new DeleteTransaction<ModelClass>(transactionInfo, table, conditions));
    }

    public <ModelClass extends Model> void delete(DBTransactionInfo transactionInfo, ConditionQueryBuilder<ModelClass> conditionQueryBuilder) {
        this.addTransaction(new DeleteTransaction<ModelClass>(transactionInfo, conditionQueryBuilder));
    }

    public <ModelClass extends Model> void update(ProcessModelInfo<ModelClass> modelInfo) {
        this.addTransaction(new UpdateModelListTransaction<ModelClass>(modelInfo));
    }

    public <ModelClass extends Model> void update(DBTransactionInfo transactionInfo, ConditionQueryBuilder<ModelClass> whereConditionBuilder, Condition ... setConditions) {
        this.addTransaction(new UpdateTransaction<ModelClass>(transactionInfo, whereConditionBuilder, setConditions));
    }

    public <ModelClass extends Model> void update(DBTransactionInfo transactionInfo, ConditionQueryBuilder<ModelClass> whereConditionBuilder, ConditionQueryBuilder<ModelClass> setConditionBuilder) {
        this.addTransaction(new UpdateTransaction<ModelClass>(transactionInfo, whereConditionBuilder, setConditionBuilder));
    }
}

