/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime.transaction;

import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.transaction.BaseTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;

public abstract class BaseResultTransaction<ResultClass>
extends BaseTransaction<ResultClass> {
    private ResultReceiver<ResultClass> mReceiver;

    public BaseResultTransaction(ResultReceiver<ResultClass> resultReceiver) {
        this(DBTransactionInfo.create(), resultReceiver);
    }

    public BaseResultTransaction(DBTransactionInfo dbTransactionInfo, ResultReceiver<ResultClass> resultReceiver) {
        super(dbTransactionInfo);
        this.mReceiver = resultReceiver;
    }

    @Override
    public boolean hasResult(ResultClass result) {
        return this.mReceiver != null;
    }

    @Override
    public void onPostExecute(ResultClass modelClasses) {
        if (this.mReceiver != null) {
            this.mReceiver.onResultReceived(modelClasses);
        }
    }
}

