/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime.transaction;

import com.grosner.dbflow.runtime.DBTransactionInfo;

public abstract class BaseTransaction<TransactionResult>
implements Comparable<BaseTransaction> {
    public static int PRIORITY_LOW = 0;
    public static int PRIORITY_NORMAL = 1;
    public static int PRIORITY_HIGH = 2;
    public static int PRIORITY_UI = 5;
    private DBTransactionInfo mInfo;

    public BaseTransaction(DBTransactionInfo dbTransactionInfo) {
        this.mInfo = dbTransactionInfo;
    }

    public BaseTransaction() {
        this.mInfo = DBTransactionInfo.create();
    }

    public boolean onReady() {
        return true;
    }

    public boolean hasResult(TransactionResult transactionResult) {
        return false;
    }

    public abstract TransactionResult onExecute();

    public void onPostExecute(TransactionResult result) {
    }

    @Override
    public int compareTo(BaseTransaction another) {
        return another.mInfo.getPriority() - this.mInfo.getPriority();
    }

    public String getName() {
        return this.mInfo.getName();
    }
}

