/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime.transaction;

import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.transaction.BaseResultTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.sql.language.Where;
import com.grosner.dbflow.structure.Model;
import java.util.List;

public class SelectListTransaction<ModelClass extends Model>
extends BaseResultTransaction<List<ModelClass>> {
    private Where<ModelClass> mWhere;

    public SelectListTransaction(ResultReceiver<List<ModelClass>> resultReceiver, Class<ModelClass> tableClass, Condition ... whereConditions) {
        this(new Select(new String[0]).from(tableClass).where(whereConditions), resultReceiver);
    }

    public SelectListTransaction(Where<ModelClass> where, ResultReceiver<List<ModelClass>> resultReceiver) {
        super(DBTransactionInfo.createFetch(), resultReceiver);
        this.mWhere = where;
    }

    public SelectListTransaction(ResultReceiver<List<ModelClass>> resultReceiver, ConditionQueryBuilder<ModelClass> whereConditionQueryBuilder, String ... columns) {
        this(new Select(columns).from(whereConditionQueryBuilder.getTableClass()).where(whereConditionQueryBuilder), resultReceiver);
    }

    public SelectListTransaction(ResultReceiver<List<ModelClass>> resultReceiver, Class<ModelClass> table, String ... columns) {
        this(new Select(columns).from(table).where(), resultReceiver);
    }

    @Override
    public boolean onReady() {
        return this.mWhere != null;
    }

    @Override
    public List<ModelClass> onExecute() {
        return this.mWhere.queryList();
    }
}

