/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime.transaction.process;

import android.support.annotation.NonNull;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.process.ProcessModel;
import com.grosner.dbflow.structure.Model;
import java.util.Collection;

public class ProcessModelHelper {
    public static <ModelClass extends Model> void process(Class<ModelClass> modelClass, final @NonNull Collection<ModelClass> collection, final ProcessModel<ModelClass> processModel) {
        if (!collection.isEmpty()) {
            TransactionManager.transact(FlowManager.getDatabaseForTable(modelClass).getWritableDatabase(), new Runnable(){

                @Override
                public void run() {
                    for (Model collectionModel : collection) {
                        processModel.processModel(collectionModel);
                    }
                }
            });
        }
    }

    @SafeVarargs
    public static <ModelClass extends Model> void process(Class<ModelClass> modelClass, ProcessModel<ModelClass> processModel, ModelClass ... models) {
        TransactionManager.transact(FlowManager.getDatabaseForTable(modelClass).getWritableDatabase(), new Runnable((Model[])models, processModel){
            final /* synthetic */ Model[] val$models;
            final /* synthetic */ ProcessModel val$processModel;
            {
                this.val$models = modelArray;
                this.val$processModel = processModel;
            }

            @Override
            public void run() {
                for (Model model : this.val$models) {
                    this.val$processModel.processModel(model);
                }
            }
        });
    }
}

