/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.runtime.transaction.process;

import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.structure.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ProcessModelInfo<ModelClass extends Model> {
    List<ModelClass> mModels = new ArrayList<ModelClass>();
    ResultReceiver<List<ModelClass>> mReceiver;
    DBTransactionInfo mInfo;
    Class<ModelClass> mTable;

    ProcessModelInfo() {
    }

    @SafeVarargs
    public static <ModelClass extends Model> ProcessModelInfo<ModelClass> withModels(ModelClass ... models) {
        return new ProcessModelInfo<ModelClass>().models((Model[])models);
    }

    public ProcessModelInfo<ModelClass> models(ModelClass ... models) {
        this.mModels.addAll(Arrays.asList(models));
        if (models.length > 0) {
            this.mTable = models[0].getClass();
        }
        return this;
    }

    public static <ModelClass extends Model> ProcessModelInfo<ModelClass> withModels(Collection<ModelClass> models) {
        return new ProcessModelInfo<ModelClass>().models(models);
    }

    public ProcessModelInfo<ModelClass> models(Collection<ModelClass> models) {
        this.mModels.addAll(models);
        if (models != null && models.size() > 0) {
            this.mTable = ((Model)new ArrayList<ModelClass>(models).get(0)).getClass();
        }
        return this;
    }

    public ProcessModelInfo<ModelClass> result(ResultReceiver<List<ModelClass>> resultReceiver) {
        this.mReceiver = resultReceiver;
        return this;
    }

    public ProcessModelInfo<ModelClass> fetch() {
        return this.info(DBTransactionInfo.create());
    }

    public ProcessModelInfo<ModelClass> info(DBTransactionInfo dbTransactionInfo) {
        this.mInfo = dbTransactionInfo;
        return this;
    }

    public DBTransactionInfo getInfo() {
        if (this.mInfo == null) {
            this.mInfo = DBTransactionInfo.create();
        }
        return this.mInfo;
    }

    public boolean hasData() {
        return !this.mModels.isEmpty();
    }
}

