/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.support.annotation.IntDef;
import com.grosner.dbflow.config.BaseDatabaseDefinition;
import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.process.DeleteModelListTransaction;
import com.grosner.dbflow.runtime.transaction.process.ProcessModelInfo;
import com.grosner.dbflow.sql.language.Delete;
import com.grosner.dbflow.structure.BaseModel;
import com.grosner.dbflow.structure.BaseModelView;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public class SqlUtils {
    @SaveMode
    public static final int SAVE_MODE_DEFAULT = 0;
    @SaveMode
    public static final int SAVE_MODE_UPDATE = 1;
    @SaveMode
    public static final int SAVE_MODE_INSERT = 2;

    public static <ModelClass extends Model> List<ModelClass> queryList(Class<ModelClass> modelClass, String sql, String ... args) {
        BaseDatabaseDefinition flowManager = FlowManager.getDatabaseForTable(modelClass);
        Cursor cursor = flowManager.getWritableDatabase().rawQuery(sql, args);
        List<ModelClass> list = SqlUtils.convertToList(modelClass, cursor);
        cursor.close();
        return list;
    }

    public static <ModelClass extends Model> List<ModelClass> convertToList(Class<ModelClass> table, Cursor cursor) {
        ArrayList<ModelClass> entities = new ArrayList<ModelClass>();
        if (cursor.moveToFirst()) {
            do {
                entities.add(SqlUtils.convertToModel(true, table, cursor));
            } while (cursor.moveToNext());
        }
        return entities;
    }

    public static <ModelClass extends Model> ModelClass convertToModel(boolean isList, Class<ModelClass> table, Cursor cursor) {
        ModelClass model = null;
        try {
            if (isList || cursor.moveToFirst()) {
                ModelAdapter<ModelClass> modelAdapter = FlowManager.getModelAdapter(table);
                if (modelAdapter == null) {
                    Class persistentClass = (Class)((ParameterizedType)table.getGenericSuperclass()).getActualTypeArguments()[0];
                    if (persistentClass.isAssignableFrom(BaseModelView.class)) {
                        model = FlowManager.getModelViewAdapter(table).loadFromCursor(cursor);
                    }
                } else {
                    model = modelAdapter.loadFromCursor(cursor);
                }
            }
        }
        catch (Exception e) {
            FlowLog.log(FlowLog.Level.E, "Failed to process cursor.", e);
        }
        return model;
    }

    public static <ModelClass extends Model> ModelClass querySingle(Class<ModelClass> modelClass, String sql, String ... args) {
        Cursor cursor = FlowManager.getDatabaseForTable(modelClass).getWritableDatabase().rawQuery(sql, args);
        ModelClass retModel = SqlUtils.convertToModel(false, modelClass, cursor);
        cursor.close();
        return retModel;
    }

    public static <ModelClass extends Model> boolean hasData(Class<ModelClass> modelClass, String sql, String ... args) {
        BaseDatabaseDefinition flowManager = FlowManager.getDatabaseForTable(modelClass);
        Cursor cursor = flowManager.getWritableDatabase().rawQuery(sql, args);
        boolean hasData = cursor.getCount() > 0;
        cursor.close();
        return hasData;
    }

    public static <ModelClass extends Model> void sync(boolean async, ModelClass model, ContentValues contentValues, @SaveMode int mode) {
        if (!async) {
            BaseDatabaseDefinition flowManager = FlowManager.getDatabaseForTable(model.getClass());
            ModelAdapter<?> modelAdapter = FlowManager.getModelAdapter(model.getClass());
            SQLiteDatabase db = flowManager.getWritableDatabase();
            boolean exists = false;
            BaseModel.Action action = BaseModel.Action.SAVE;
            if (mode == 0) {
                exists = modelAdapter.exists(model);
            } else if (mode == 1) {
                exists = true;
                action = BaseModel.Action.UPDATE;
            } else {
                action = BaseModel.Action.INSERT;
            }
            if (exists) {
                boolean bl = exists = db.update(modelAdapter.getTableName(), contentValues, modelAdapter.getPrimaryModelWhere(model).getQuery(), null) != 0;
            }
            if (!exists) {
                long id = db.insert(modelAdapter.getTableName(), null, contentValues);
                modelAdapter.updateAutoIncrement(model, id);
            }
            SqlUtils.notifyModelChanged(model.getClass(), action);
        } else {
            TransactionManager.getInstance().save(ProcessModelInfo.withModels((Model[])new Model[]{model}).info(DBTransactionInfo.create()));
        }
    }

    public static <ModelClass extends Model> void delete(ModelClass model, ModelAdapter<ModelClass> modelAdapter, boolean async) {
        if (!async) {
            new Delete().from(model.getClass()).where(modelAdapter.getPrimaryModelWhere(model)).query();
            SqlUtils.notifyModelChanged(model.getClass(), BaseModel.Action.DELETE);
        } else {
            TransactionManager.getInstance().addTransaction(new DeleteModelListTransaction(ProcessModelInfo.withModels((Model[])new Model[]{model}).fetch()));
        }
    }

    public static void notifyModelChanged(Class<? extends Model> modelClass, BaseModel.Action action) {
        FlowManager.getContext().getContentResolver().notifyChange(SqlUtils.getNotificationUri(modelClass, action), null, true);
    }

    public static Uri getNotificationUri(Class<? extends Model> modelClass, BaseModel.Action action) {
        String mode = "";
        if (action != null) {
            mode = "#" + action.name();
        }
        return Uri.parse((String)("dbflow://" + FlowManager.getTableName(modelClass) + mode));
    }

    @IntDef
    public static @interface SaveMode {
    }
}

