/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.builder;

import android.database.DatabaseUtils;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.converter.TypeConverter;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.structure.Model;
import com.grosner.dbflow.structure.ModelAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConditionQueryBuilder<ModelClass extends Model>
extends QueryBuilder<ConditionQueryBuilder<ModelClass>> {
    private static final String EMPTY_PARAM = "?";
    private ModelAdapter<ModelClass> mModelAdapter;
    private LinkedHashMap<String, Condition> mParams = new LinkedHashMap();
    private boolean isChanged = false;
    private boolean useEmptyParams = false;
    private String mSeparator = "AND";

    public ConditionQueryBuilder(Class<ModelClass> table, Condition ... conditions) {
        this.mModelAdapter = FlowManager.getModelAdapter(table);
        this.putConditions(conditions);
    }

    public ConditionQueryBuilder<ModelClass> putConditions(Condition ... conditions) {
        if (conditions.length > 0) {
            for (Condition condition : conditions) {
                this.mParams.put(condition.columnName(), condition);
            }
            this.isChanged = true;
        }
        return this;
    }

    public String getQuery() {
        if (this.isChanged || this.mQuery.length() == 0) {
            this.isChanged = false;
            this.mQuery = new StringBuilder();
            Set<String> keys = this.mParams.keySet();
            int count = 0;
            for (String key : keys) {
                this.appendConditionToQuery(this.mParams.get(key));
                if (count < keys.size() - 1) {
                    this.appendSpaceSeparated(this.mSeparator);
                }
                ++count;
            }
        }
        return this.mQuery.toString();
    }

    public String convertValueToString(Object value) {
        String stringVal;
        TypeConverter typeConverter;
        if (!this.useEmptyParams && value != null && (typeConverter = FlowManager.getTypeConverterForClass(value.getClass())) != null) {
            value = typeConverter.getDBValue(value);
        }
        if (value instanceof Number) {
            stringVal = String.valueOf(value);
        } else {
            stringVal = String.valueOf(value);
            if (!stringVal.equals(EMPTY_PARAM)) {
                stringVal = DatabaseUtils.sqlEscapeString((String)stringVal);
            }
        }
        return stringVal;
    }

    ConditionQueryBuilder<ModelClass> appendConditionToQuery(Condition condition) {
        return (ConditionQueryBuilder)((ConditionQueryBuilder)((ConditionQueryBuilder)this.append(condition.columnName())).appendSpaceSeparated(condition.operation())).append(this.convertValueToString(condition.value()));
    }

    public ConditionQueryBuilder<ModelClass> setSeparator(String separator) {
        this.mSeparator = separator;
        return this;
    }

    public ConditionQueryBuilder<ModelClass> setUseEmptyParams(boolean useEmptyParams) {
        this.useEmptyParams = useEmptyParams;
        return this;
    }

    public ConditionQueryBuilder<ModelClass> putCondition(String columnName, Object value) {
        return this.putCondition(columnName, "=", value);
    }

    public ConditionQueryBuilder<ModelClass> putCondition(String columnName, String operator, Object value) {
        if (this.useEmptyParams && !EMPTY_PARAM.equals(value)) {
            throw new IllegalStateException("The " + ConditionQueryBuilder.class.getSimpleName() + " is " + "operating in empty param mode. All params must be empty");
        }
        return this.putCondition(Condition.column(columnName).operation(operator).value(value));
    }

    public ConditionQueryBuilder<ModelClass> putCondition(Condition condition) {
        this.mParams.put(condition.columnName(), condition);
        this.isChanged = true;
        return this;
    }

    public ConditionQueryBuilder<ModelClass> emptyPrimaryConditions() {
        return (ConditionQueryBuilder)this.append(this.mModelAdapter.getPrimaryModelWhere());
    }

    public ConditionQueryBuilder<ModelClass> putConditionMap(Map<String, Condition> params) {
        if (params != null && !params.isEmpty()) {
            this.mParams.putAll(params);
            this.isChanged = true;
        }
        return this;
    }

    public ConditionQueryBuilder<ModelClass> emptyCondition(String columnName) {
        this.useEmptyParams = true;
        return this.putCondition(columnName, EMPTY_PARAM);
    }

    public String getRawQuery() {
        QueryBuilder rawQuery = new QueryBuilder();
        Set<String> keys = this.mParams.keySet();
        int count = 0;
        for (String key : keys) {
            Condition condition = this.mParams.get(key);
            rawQuery.append((Object)condition.columnName()).appendSpaceSeparated(condition.operation()).append(condition.value());
            if (count < keys.size() - 1) {
                rawQuery.appendSpaceSeparated(this.mSeparator);
            }
            ++count;
        }
        return rawQuery.toString();
    }

    public ConditionQueryBuilder<ModelClass> replaceEmptyParams(Object ... values) {
        if (!this.useEmptyParams) {
            throw new IllegalStateException("The " + ConditionQueryBuilder.class.getSimpleName() + " is " + "not operating in empty param mode.");
        }
        if (this.mParams.size() != values.length) {
            throw new IllegalArgumentException("The count of values MUST match the number of columns they correspond to for " + this.mModelAdapter.getTableName());
        }
        ConditionQueryBuilder<ModelClass> conditionQueryBuilder = new ConditionQueryBuilder<ModelClass>(this.mModelAdapter.getModelClass(), new Condition[0]);
        Set<String> columnNames = this.mParams.keySet();
        int count = 0;
        for (String columnName : columnNames) {
            conditionQueryBuilder.putCondition(columnName, values[count]);
            ++count;
        }
        return conditionQueryBuilder;
    }

    public Class<ModelClass> getTableClass() {
        return this.getModelAdapter().getModelClass();
    }

    public ModelAdapter<ModelClass> getModelAdapter() {
        return this.mModelAdapter;
    }
}

