/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.language;

import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.From;
import com.grosner.dbflow.structure.Model;

public class Join<ModelClass extends Model, FromClass extends Model>
implements Query {
    private Class<ModelClass> mTable;
    private JoinType mJoinType;
    private From<FromClass> mFrom;
    private String mAlias;
    private ConditionQueryBuilder<ModelClass> mOn;
    private String[] mUsing;
    private boolean isNatural = false;

    Join(From<FromClass> from, Class<ModelClass> table, JoinType joinType) {
        this.mFrom = from;
        this.mTable = table;
        this.mJoinType = joinType;
    }

    public Join as(String alias) {
        this.mAlias = alias;
        return this;
    }

    public From<FromClass> natural() {
        this.isNatural = true;
        return this.mFrom;
    }

    public From<FromClass> on(Condition ... onConditions) {
        this.mOn = new ConditionQueryBuilder<ModelClass>(this.mTable, onConditions);
        return this.mFrom;
    }

    public From<FromClass> using(String ... columns) {
        this.mUsing = columns;
        return this.mFrom;
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (this.isNatural) {
            queryBuilder.append((Object)"NATURAL ");
        }
        queryBuilder.append((Object)this.mJoinType.toString()).appendSpace();
        queryBuilder.append((Object)"JOIN").appendSpace().append((Object)FlowManager.getTableName(this.mTable)).appendSpace();
        if (this.mAlias != null) {
            queryBuilder.append((Object)"AS ").append((Object)this.mAlias).appendSpace();
        }
        if (this.mOn != null) {
            queryBuilder.append((Object)"ON").appendSpace().append((Object)this.mOn.getRawQuery()).appendSpace();
        } else if (this.mUsing != null) {
            queryBuilder.append((Object)"USING (").appendArray((Object[])this.mUsing).append((Object)")").appendSpace();
        }
        return queryBuilder.getQuery();
    }

    public static enum JoinType {
        LEFT,
        OUTER,
        INNER,
        CROSS;

    }
}

