/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.language;

import android.text.TextUtils;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.From;
import com.grosner.dbflow.sql.language.Where;
import com.grosner.dbflow.structure.Model;
import java.util.List;

public class Select
implements Query {
    public static final int NONE = -1;
    private int mSelectQualifier = -1;
    public static final int DISTINCT = 0;
    public static final int ALL = 1;
    public static final int METHOD = 2;
    private final String[] mColumns;
    private String mMethodName;
    private String mColumnName;

    public Select(String ... columns) {
        this.mColumns = columns;
    }

    public static <ModelClass extends Model> ModelClass byId(Class<ModelClass> tableClass, Object ... ids) {
        ConditionQueryBuilder<ModelClass> primaryQuery = FlowManager.getPrimaryWhereQuery(tableClass);
        return Select.withCondition(primaryQuery.replaceEmptyParams(ids), new String[0]);
    }

    public static <ModelClass extends Model> ModelClass withCondition(ConditionQueryBuilder<ModelClass> conditionQueryBuilder, String ... columns) {
        return Where.with(conditionQueryBuilder, columns).querySingle();
    }

    public static <ModelClass extends Model> List<ModelClass> all(Class<ModelClass> tableClass, Condition ... conditions) {
        return new Select(new String[0]).from(tableClass).where(conditions).queryList();
    }

    public <ModelClass extends Model> From<ModelClass> from(Class<ModelClass> table) {
        return new From<ModelClass>(this, table);
    }

    public static <ModelClass extends Model> List<ModelClass> all(ConditionQueryBuilder<ModelClass> conditionQueryBuilder, String ... columns) {
        return Where.with(conditionQueryBuilder, columns).queryList();
    }

    public Select distinct() {
        return this.selectQualifier(0);
    }

    public Select selectQualifier(int qualifierInt) {
        this.mSelectQualifier = qualifierInt;
        return this;
    }

    public Select all() {
        return this.selectQualifier(1);
    }

    public Select count() {
        return this.method("COUNT", "*");
    }

    public Select method(String methodName, String columnName) {
        this.mMethodName = methodName;
        this.mColumnName = columnName;
        return this.selectQualifier(2);
    }

    public Select avg(String columnName) {
        return this.method("AVG", columnName);
    }

    public Select sum(String columnName) {
        return this.method("SUM", columnName);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.append((Object)"SELECT").appendSpace();
        if (this.mSelectQualifier != -1) {
            if (this.mSelectQualifier == 0) {
                queryBuilder.append((Object)"DISTINCT");
            } else if (this.mSelectQualifier == 1) {
                queryBuilder.append((Object)"ALL");
            } else if (this.mSelectQualifier == 2) {
                queryBuilder.append((Object)this.mMethodName.toUpperCase()).appendParenthesisEnclosed(this.mColumnName);
            }
            queryBuilder.appendSpace();
        }
        if (this.mColumns != null && this.mColumns.length > 0) {
            queryBuilder.append((Object)TextUtils.join((CharSequence)", ", (Object[])this.mColumns));
        } else if (this.mSelectQualifier != 2) {
            queryBuilder.append((Object)"*");
        }
        queryBuilder.appendSpace();
        return queryBuilder.getQuery();
    }
}

