/*
 * Decompiled with CFR 0.152.
 */
package com.grosner.dbflow.sql.language;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import com.grosner.dbflow.config.BaseDatabaseDefinition;
import com.grosner.dbflow.config.FlowLog;
import com.grosner.dbflow.config.FlowManager;
import com.grosner.dbflow.runtime.DBTransactionInfo;
import com.grosner.dbflow.runtime.TransactionManager;
import com.grosner.dbflow.runtime.transaction.QueryTransaction;
import com.grosner.dbflow.runtime.transaction.ResultReceiver;
import com.grosner.dbflow.sql.Queriable;
import com.grosner.dbflow.sql.Query;
import com.grosner.dbflow.sql.QueryBuilder;
import com.grosner.dbflow.sql.SqlUtils;
import com.grosner.dbflow.sql.builder.Condition;
import com.grosner.dbflow.sql.builder.ConditionQueryBuilder;
import com.grosner.dbflow.sql.language.Select;
import com.grosner.dbflow.sql.language.WhereBase;
import com.grosner.dbflow.structure.Model;
import java.util.List;
import java.util.Map;

public class Where<ModelClass extends Model>
implements Query,
Queriable<ModelClass> {
    private final WhereBase<ModelClass> mWhereBase;
    private final BaseDatabaseDefinition mManager;
    private ConditionQueryBuilder<ModelClass> mConditionQueryBuilder;
    private String mGroupBy;
    private ConditionQueryBuilder<ModelClass> mHaving;
    private String mOrderBy;
    private String mLimit;
    private String mOffset;

    public Where(WhereBase<ModelClass> whereBase) {
        this.mWhereBase = whereBase;
        this.mManager = FlowManager.getDatabaseForTable(this.mWhereBase.getTable());
        this.mConditionQueryBuilder = new ConditionQueryBuilder<ModelClass>(this.mWhereBase.getTable(), new Condition[0]);
        this.mHaving = new ConditionQueryBuilder<ModelClass>(this.mWhereBase.getTable(), new Condition[0]);
    }

    public static <ModelClass extends Model> Where<ModelClass> with(ConditionQueryBuilder<ModelClass> conditionQueryBuilder, String ... columns) {
        return new Select(columns).from(conditionQueryBuilder.getTableClass()).where(conditionQueryBuilder);
    }

    public Where<ModelClass> whereClause(String whereClause) {
        this.mConditionQueryBuilder.append(whereClause);
        return this;
    }

    public Where<ModelClass> whereQuery(ConditionQueryBuilder<ModelClass> conditionQueryBuilder) {
        if (conditionQueryBuilder != null) {
            this.mConditionQueryBuilder = conditionQueryBuilder;
        }
        return this;
    }

    public Where<ModelClass> and(String columnName, Object value) {
        this.mConditionQueryBuilder.putCondition(columnName, value);
        return this;
    }

    public Where<ModelClass> and(String columnName, String operator, Object value) {
        this.mConditionQueryBuilder.putCondition(columnName, operator, value);
        return this;
    }

    public Where<ModelClass> and(Condition condition) {
        this.mConditionQueryBuilder.putCondition(condition);
        return this;
    }

    public Where<ModelClass> andThese(Map<String, Condition> conditionMap) {
        this.mConditionQueryBuilder.putConditionMap(conditionMap);
        return this;
    }

    public Where<ModelClass> andThese(Condition ... conditions) {
        this.mConditionQueryBuilder.putConditions(conditions);
        return this;
    }

    public Where<ModelClass> groupBy(QueryBuilder groupBy) {
        this.mGroupBy = groupBy.getQuery();
        return this;
    }

    public Where<ModelClass> having(Condition ... conditions) {
        this.mHaving.putConditions(conditions);
        return this;
    }

    public Where<ModelClass> orderBy(boolean ascending, String ... columns) {
        this.mOrderBy = new QueryBuilder().appendArray((Object[])columns).appendSpace().append((Object)(ascending ? "ASC" : "DSC")).getQuery();
        return this;
    }

    public Where<ModelClass> orderBy(String orderby) {
        this.mOrderBy = orderby;
        return this;
    }

    public Where<ModelClass> limit(Object limit) {
        this.mLimit = String.valueOf(limit);
        return this;
    }

    public Where<ModelClass> offset(Object offset) {
        this.mOffset = String.valueOf(offset);
        return this;
    }

    public long count() {
        return DatabaseUtils.longForQuery((SQLiteDatabase)this.mManager.getWritableDatabase(), (String)this.getQuery(), null);
    }

    public String getQuery() {
        String fromQuery = this.mWhereBase.getQuery();
        QueryBuilder queryBuilder = new QueryBuilder().append((Object)fromQuery);
        queryBuilder.appendQualifier("WHERE", this.mConditionQueryBuilder.getQuery()).appendQualifier("GROUP BY", this.mGroupBy).appendQualifier("HAVING", this.mHaving.getQuery()).appendQualifier("ORDER BY", this.mOrderBy).appendQualifier("LIMIT", this.mLimit).appendQualifier("OFFSET", this.mOffset);
        if (FlowLog.isEnabled(FlowLog.Level.V)) {
            FlowLog.log(FlowLog.Level.V, queryBuilder.getQuery());
        }
        return queryBuilder.getQuery();
    }

    @Override
    public Cursor query() {
        Cursor cursor = null;
        String query = this.getQuery();
        if (this.mWhereBase.getQueryBuilderBase() instanceof Select) {
            cursor = this.mManager.getWritableDatabase().rawQuery(query, null);
        } else {
            this.mManager.getWritableDatabase().execSQL(query);
        }
        return cursor;
    }

    @Override
    public List<ModelClass> queryList() {
        this.checkSelect("query");
        return SqlUtils.queryList(this.mWhereBase.getTable(), this.getQuery(), new String[0]);
    }

    protected void checkSelect(String methodName) {
        if (!(this.mWhereBase.getQueryBuilderBase() instanceof Select)) {
            throw new IllegalArgumentException("Please use " + methodName + "(). The beginning is not a Select");
        }
    }

    @Override
    public ModelClass querySingle() {
        this.checkSelect("query");
        return SqlUtils.querySingle(this.mWhereBase.getTable(), this.getQuery(), new String[0]);
    }

    public void transact(DBTransactionInfo transactionInfo) {
        this.transact(transactionInfo, TransactionManager.getInstance());
    }

    public void transact(DBTransactionInfo transactionInfo, TransactionManager transactionManager) {
        transactionManager.addTransaction(new QueryTransaction(transactionInfo, this));
    }

    public void transactList(ResultReceiver<List<ModelClass>> listResultReceiver) {
        this.transactList(TransactionManager.getInstance(), listResultReceiver);
    }

    public void transactList(TransactionManager transactionManager, ResultReceiver<List<ModelClass>> listResultReceiver) {
        this.checkSelect("transact");
        transactionManager.fetchFromTable(this, listResultReceiver);
    }

    public void transactSingleModel(ResultReceiver<ModelClass> resultReceiver) {
        this.transactSingleModel(TransactionManager.getInstance(), resultReceiver);
    }

    public void transactSingleModel(TransactionManager transactionManager, ResultReceiver<ModelClass> resultReceiver) {
        this.checkSelect("transact");
        transactionManager.fetchModel(this, resultReceiver);
    }

    public boolean hasData() {
        this.checkSelect("query");
        return SqlUtils.hasData(this.mWhereBase.getTable(), this.getQuery(), new String[0]);
    }

    public Class<ModelClass> getTable() {
        return this.mWhereBase.getTable();
    }

    public String toString() {
        return this.getQuery();
    }
}

