package rest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;


@Component
public class FapApi {

    private final static Logger logger = LoggerFactory.getLogger(FapApi.class);

    @Autowired
    private RestTemplate restTemplate;

    public String url;

    @PostConstruct
    public void initUrl(){
        String url = restTemplate.getForObject("http://202.121.23.66/FAP.IdentityServer/PublicInfo/getApplicationUri?name=FAP.Api",String.class);
        this.url = url;
        logger.info("【get fap uri】"+url);
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
