/*
 * Decompiled with CFR 0.152.
 */
package rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.stereotype.Service;
import rest.BodyResult;
import rest.FapApi;
import rest.FapApiConfig;
import rest.FapRequestException;
import rest.FapUserInfo;
import rest.FapUserInfoQo;
import rest.FapUserRoleInfo;
import rest.RefreshInfo;
import rest.RefreshTokenQo;
import rest.Result;
import rest.ShpcBasicService;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.GsonConverterFactory;
import retrofit2.Response;
import retrofit2.Retrofit;

@Service
public class ShpcBasicImpService {
    @Autowired
    FapApiConfig fapApiConfig;
    @Autowired
    FapApi fapApi;
    @Autowired
    private OAuth2AuthorizedClientService clientService;
    private static String zone = "Asia/Shanghai";
    @Value(value="${spring.security.oauth2.client.registration.fap.client-id}")
    private String clientId;
    @Value(value="${spring.security.oauth2.client.registration.fap.client-secret}")
    private String secret;
    private Retrofit retrofit1;
    private ShpcBasicService service1;
    Retrofit retrofit = new Retrofit.Builder().baseUrl("http://202.121.23.66/fap.identityserver/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    ShpcBasicService service = (ShpcBasicService)this.retrofit.create(ShpcBasicService.class);
    private static Logger logger = LoggerFactory.getLogger(ShpcBasicImpService.class);
    ObjectMapper objectMapper = new ObjectMapper();

    @PostConstruct
    public void init() {
        this.retrofit1 = new Retrofit.Builder().baseUrl(this.fapApi.getUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
        this.service1 = (ShpcBasicService)this.retrofit1.create(ShpcBasicService.class);
    }

    public Result getUserInfoByUid(Principal principal) throws IOException, FapRequestException, NoSuchFieldException {
        this.oAuth2TokenDetaiInject(principal);
        OAuth2AuthenticationToken oauthToken = (OAuth2AuthenticationToken)principal;
        OidcIdToken token = ((DefaultOidcUser)oauthToken.getPrincipal()).getIdToken();
        String uid = token.getClaims().get("sub").toString();
        String accessToken = this.getAccessTokenValue(oauthToken);
        Call<BodyResult> call = this.service1.getUserById(accessToken, uid);
        Response response = call.execute();
        BodyResult result = this.getBodyResult(response);
        FapUserInfo userInfo = result.getResult();
        FapUserInfoQo fapUserInfoQo = new FapUserInfoQo();
        fapUserInfoQo.transformUserInfo(userInfo);
        return Result.initResult().suc(fapUserInfoQo);
    }

    private String getAccessTokenValue(OAuth2AuthenticationToken oauthToken) {
        RefreshTokenQo qo = (RefreshTokenQo)this.objectMapper.convertValue(oauthToken.getDetails(), RefreshTokenQo.class);
        return "Bearer " + qo.getAccessTokenValue();
    }

    public List<FapUserRoleInfo> getUserRoleByUnitRole(Principal principal, String orgId, String roleType) throws FapRequestException, IOException {
        this.oAuth2TokenDetaiInject(principal);
        OAuth2AuthenticationToken oauthToken = (OAuth2AuthenticationToken)principal;
        String accessToken = this.getAccessTokenValue(oauthToken);
        String roleId = this.getRoleId(roleType);
        Call<BodyResult> call = this.service1.getUserRoleByUnitRole(accessToken, orgId, roleId, true, true, 0, 20);
        Response response = call.execute();
        BodyResult result = this.getBodyResult(response);
        return result.getResults();
    }

    public List<FapUserRoleInfo> getUserInfoByUserInfo(Principal principal, String query) throws FapRequestException, IOException {
        this.oAuth2TokenDetaiInject(principal);
        OAuth2AuthenticationToken oauthToken = (OAuth2AuthenticationToken)principal;
        String accessToken = this.getAccessTokenValue(oauthToken);
        Call<BodyResult> call = this.service1.getUserInfoByUserInfo(accessToken, this.fapApiConfig.getDomainId(), query, true, 0, 20);
        Response response = call.execute();
        BodyResult result = this.getBodyResult(response);
        return result.getResults();
    }

    public boolean userBelongToRole(String uid, List<FapUserRoleInfo> list) {
        boolean valid = false;
        for (FapUserRoleInfo userRole : list) {
            if (!userRole.getUserId().equals(uid)) continue;
            valid = true;
        }
        return valid;
    }

    private String getRoleId(String roleType) {
        String roleId = "";
        if (roleType.equals("primaryManager")) {
            roleId = this.fapApiConfig.getPrimaryManager();
        } else if (roleType.equals("minorManager")) {
            roleId = this.fapApiConfig.getMinorManager();
        } else if (roleType.equals("secretary")) {
            roleId = this.fapApiConfig.getSecretary();
        } else if (roleType.equals("groupDiscussion")) {
            roleId = this.fapApiConfig.getSecretary();
        } else if (roleType.equals("recheckManager")) {
            roleId = this.fapApiConfig.getSecretary();
        } else if (roleType.equals("finalManager")) {
            roleId = this.fapApiConfig.getSecretary();
        }
        return roleId;
    }

    private BodyResult getBodyResult(Response response) throws FapRequestException {
        if (response.raw().code() == 401) {
            throw new FapRequestException(100);
        }
        if (!response.isSuccessful()) {
            throw new FapRequestException(100);
        }
        BodyResult result = (BodyResult)response.body();
        assert (result != null);
        if (!Strings.isNullOrEmpty((String)result.getError())) {
            throw new FapRequestException(200);
        }
        return result;
    }

    private String getAccessToken(OAuth2AuthenticationToken oauthToken) {
        OAuth2AuthorizedClient client = this.clientService.loadAuthorizedClient(oauthToken.getAuthorizedClientRegistrationId(), oauthToken.getName());
        OAuth2AccessToken accessToken = client.getAccessToken();
        OAuth2RefreshToken refreshToken = client.getRefreshToken();
        String tokenStr = "Bearer " + accessToken.getTokenValue();
        logger.info("\u3010accessToken\u3011:{}", (Object)tokenStr);
        logger.info("\u3010refreshToken\u3011:{}", (Object)refreshToken.getTokenValue());
        return tokenStr;
    }

    public void oAuth2TokenDetaiInject(Principal principal) throws IOException {
        OAuth2AuthenticationToken oauthToken = (OAuth2AuthenticationToken)principal;
        OidcIdToken token = ((DefaultOidcUser)oauthToken.getPrincipal()).getIdToken();
        OAuth2AuthorizedClient client = this.clientService.loadAuthorizedClient(oauthToken.getAuthorizedClientRegistrationId(), oauthToken.getName());
        ObjectMapper objectMapper = new ObjectMapper();
        Class<?> cls = oauthToken.getDetails().getClass();
        if (!cls.getSimpleName().equals("RefreshTokenQo")) {
            RefreshTokenQo tokenQo = new RefreshTokenQo(client.getAccessToken().getTokenValue(), LocalDateTime.now().toString(), client.getRefreshToken().getTokenValue(), LocalDateTime.now().toString());
            oauthToken.setDetails((Object)tokenQo);
        }
        ZonedDateTime zonedDateTime = token.getExpiresAt().atZone(ZoneId.of(zone));
        boolean expire = zonedDateTime.toLocalDateTime().isBefore(LocalDateTime.now());
        RefreshInfo refreshInfo = new RefreshInfo();
        if (expire) {
            RefreshTokenQo qo = (RefreshTokenQo)objectMapper.convertValue(oauthToken.getDetails(), RefreshTokenQo.class);
            Call<RefreshInfo> accessCall = this.service.getAccessToken(this.clientId, this.secret, "refresh_token", qo.getRefreshTokenValue());
            Response aresponse = accessCall.execute();
            refreshInfo = (RefreshInfo)aresponse.body();
            oauthToken.setDetails((Object)new RefreshTokenQo(refreshInfo.getAccess_token(), LocalDateTime.now().plusSeconds(3600L).toString(), refreshInfo.getRefresh_token(), LocalDateTime.now().toString()));
        }
    }
}

