package com.github.aidensuen.mongo.spring;

import com.github.aidensuen.mongo.session.ExecutorType;
import com.github.aidensuen.mongo.session.MongoSession;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.transaction.support.ResourceHolderSupport;

public final class MongoSessionHolder extends ResourceHolderSupport {

    private final MongoSession mongoSession;
    private final ExecutorType executorType;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public MongoSessionHolder(MongoSession mongoSession, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        this.mongoSession = mongoSession;
        this.executorType = executorType;
        this.exceptionTranslator = exceptionTranslator;
    }

    public MongoSession getMongoSession() {
        return mongoSession;
    }

    public ExecutorType getExecutorType() {
        return executorType;
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return exceptionTranslator;
    }
}
