package com.github.aidensuen.mongo.spring.annotation;

import com.github.aidensuen.mongo.spring.mongodao.MongoDaoFactoryBean;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
@Import(MongoDaoScannerRegistrar.class)
public @interface MongoDaoScan {

    /**
     * Alias for the {@link #basePackages()} attribute. Allows for more concise
     * com.github.aidensuen.spring.annotation declarations
     */
    String[] value() default {};

    /**
     * Base packages to scan for mongo interfaces. Note that only interfaces
     * with at least one method will be registered; concrete classes will be
     * ignored.
     */
    String[] basePackages() default {};

    /**
     * Type-safe alternative to {@link #basePackages()} for specifying the packages
     * to scan for annotated components. The package of each class specified will be scanned.
     * <p>Consider creating a special no-op marker class or interface in each package
     * that serves no purpose other than being referenced by this attribute.
     */
    Class<?>[] basePackageClasses() default {};

    Class<? extends BeanNameGenerator> nameGenerator() default BeanNameGenerator.class;

    Class<? extends Annotation> annotationClass() default Annotation.class;

    Class<?> markerInterface() default Class.class;

    String mongoSessionTemplateRef() default "";

    String mongoSessionFactoryRef() default "";

    Class<? extends MongoDaoFactoryBean> factoryBean() default MongoDaoFactoryBean.class;

    String mongoDaoRepositoryRef() default "";

    String[] properties() default {};

}
