package com.github.aidensuen.mongo.spring.annotation;


import com.github.aidensuen.mongo.spring.mongodao.ClassPathMongoDaoScanner;
import com.github.aidensuen.mongo.spring.mongodao.MongoDaoFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class MongoDaoScannerRegistrar implements ImportBeanDefinitionRegistrar, EnvironmentAware {

    public static final Logger LOGGER = LoggerFactory.getLogger(MongoDaoScannerRegistrar.class);

    private Environment environment;

    @Override
    public void registerBeanDefinitions(
            AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(importingClassMetadata.getAnnotationAttributes(MongoDaoScan.class.getName()));

        ClassPathMongoDaoScanner scanner = new ClassPathMongoDaoScanner(registry);

        Class<? extends Annotation> annotationClass = attributes.getClass("annotationClass");
        if (!Annotation.class.equals(annotationClass)) {
            scanner.setAnnotationClass(annotationClass);
        }

        Class<?> markerInterface = attributes.getClass("markerInterface");
        if (!Class.class.equals(markerInterface)) {
            scanner.setMarkerInterface(markerInterface);
        }

        Class<? extends BeanNameGenerator> generatorClass = attributes.getClass("nameGenerator");
        if (!BeanNameGenerator.class.equals(generatorClass)) {
            scanner.setBeanNameGenerator(BeanUtils.instantiateClass(generatorClass));
        }

        Class<? extends MongoDaoFactoryBean> mongoDaorFactoryBeanClass = attributes.getClass("factoryBean");
        if (!MongoDaoFactoryBean.class.equals(mongoDaorFactoryBeanClass)) {
            scanner.setMongoDaoFactoryBean(BeanUtils.instantiateClass(mongoDaorFactoryBeanClass));
        }

        scanner.setMongoSessionTemplateBeanName(attributes.getString("mongoSessionTemplateRef"));
        scanner.setMongoSessionFactoryBeanName(attributes.getString("mongoSessionFactoryRef"));

        String mongoDaoRepositoryRef = attributes.getString("mongoDaoRepositoryRef");
        String[] properties = attributes.getStringArray("properties");
        if (StringUtils.hasText(mongoDaoRepositoryRef)) {
            scanner.setMongoDaoRepositoryBeaName(mongoDaoRepositoryRef);
        } else if (properties != null && properties.length > 0) {
            scanner.setMongoDaoProperties(properties);
        } else {
            try {
                scanner.setMongoDaoProperties(this.environment);
            } catch (Exception e) {
                LOGGER.warn(e.toString());
            }
        }

        List<String> basePackages = new ArrayList<String>();
        for (String pkg : attributes.getStringArray("value")) {
            if (StringUtils.hasText(pkg)) {
                basePackages.add(pkg);
            }
        }
        for (String pkg : attributes.getStringArray("basePackages")) {
            if (StringUtils.hasText(pkg)) {
                basePackages.add(pkg);
            }
        }
        for (Class<?> clazz : attributes.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName(clazz));
        }
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}
