package com.github.aidensuen.mongo.spring.support;

import com.github.aidensuen.mongo.session.MongoSession;
import com.github.aidensuen.mongo.session.MongoSessionFactory;
import com.github.aidensuen.mongo.spring.MongoSessionTemplate;
import org.springframework.dao.support.DaoSupport;

import static org.springframework.util.Assert.notNull;

public abstract class MongoDaoSupport extends DaoSupport {

    private MongoSession mongoSession;
    private boolean externalMongoSession;

    public void setMongoSessionFactory(MongoSessionFactory mongoSessionFactory) {
        if (!externalMongoSession) {
            this.mongoSession = new MongoSessionTemplate(mongoSessionFactory);
        }
    }

    public void setMongoSessionTemplate(MongoSessionTemplate mongoSessionTemplate) {
        this.mongoSession = mongoSessionTemplate;
        this.externalMongoSession = true;
    }

    @Override
    protected void checkDaoConfig() {
        notNull(this.mongoSession, "Property 'mongoSession' are required");
    }

    protected MongoSession getMongoSession() {
        return this.mongoSession;
    }

}
