/*
 * Decompiled with CFR 0.152.
 */
package com.github.aidensuen.mongo.spring;

import com.github.aidensuen.mongo.session.Configuration;
import com.github.aidensuen.mongo.session.ExecutorType;
import com.github.aidensuen.mongo.session.MongoSession;
import com.github.aidensuen.mongo.session.MongoSessionFactory;
import com.github.aidensuen.mongo.spring.MongoSessionUtils;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.util.Assert;

public class MongoSessionTemplate
implements MongoSession {
    private final MongoSessionFactory mongoSessionFactory;
    private final ExecutorType executorType;
    private final MongoSession mongoSessionProxy;
    private final PersistenceExceptionTranslator exceptionTranslator;

    public MongoSessionTemplate(MongoSessionFactory mongoSessionFactory) {
        this(mongoSessionFactory, mongoSessionFactory.getConfiguration().getDefaultExecutorType());
    }

    public MongoSessionTemplate(MongoSessionFactory mongoSessionFactory, ExecutorType executorType) {
        this(mongoSessionFactory, executorType, (PersistenceExceptionTranslator)new MongoExceptionTranslator());
    }

    public MongoSessionTemplate(MongoSessionFactory mongoSessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)mongoSessionFactory, (String)"Property 'mongoSessionFactory' is required");
        Assert.notNull((Object)executorType, (String)"Property 'executorType' is required");
        this.mongoSessionFactory = mongoSessionFactory;
        this.executorType = executorType;
        this.exceptionTranslator = exceptionTranslator;
        this.mongoSessionProxy = (MongoSession)Proxy.newProxyInstance(MongoSessionFactory.class.getClassLoader(), new Class[]{MongoSession.class}, (InvocationHandler)new MongoSessionIntercetor());
    }

    public MongoSessionFactory getMongoSessionFactory() {
        return this.mongoSessionFactory;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public MongoDatabase getDb() {
        return this.mongoSessionProxy.getDb();
    }

    public Configuration getConfiguration() {
        return this.mongoSessionFactory.getConfiguration();
    }

    public <T> T save(String statement, T objectToSave) {
        return (T)this.mongoSessionProxy.save(statement, objectToSave);
    }

    public <T> T insert(String statement, T objectToSave) {
        return (T)this.mongoSessionProxy.insert(statement, objectToSave);
    }

    public <T> Collection<T> insert(String statement, Collection<? extends T> batchToSave) {
        return this.mongoSessionProxy.insert(statement, batchToSave);
    }

    public DeleteResult remove(String statement, Object parameter) {
        return this.mongoSessionProxy.remove(statement, parameter);
    }

    public <T> T findOne(String statement, Object parameter) {
        return (T)this.mongoSessionProxy.findOne(statement, parameter);
    }

    public <T> List<T> find(String statement, Object parameter) {
        return this.mongoSessionProxy.find(statement, parameter);
    }

    public <T> List<T> find(String statement, Object parameter, Pageable pageable) {
        return this.mongoSessionProxy.find(statement, parameter, pageable);
    }

    public <T, R> List<R> find(String statement, Object parameter, Function<T, R> converter) {
        return this.mongoSessionProxy.find(statement, parameter, converter);
    }

    public <T, R> List<R> find(String statement, Object parameter, Pageable pageable, Function<T, R> converter) {
        return this.mongoSessionProxy.find(statement, parameter, pageable, converter);
    }

    public <k, v> Map<k, v> findMap(String statement, Object parameter, String mapKey) {
        return this.mongoSessionProxy.findMap(statement, parameter, mapKey);
    }

    public <k, v> Map<k, v> findMap(String statement, Object parameter, String mapKey, Pageable pageable) {
        return this.mongoSessionProxy.findMap(statement, parameter, mapKey, pageable);
    }

    public long count(String statement, Object parameter) {
        return this.mongoSessionProxy.count(statement, parameter);
    }

    public boolean exists(String statement, Object parameter) {
        return this.mongoSessionProxy.exists(statement, parameter);
    }

    public UpdateResult updateFirst(String statement, Object parameter) {
        return this.mongoSessionProxy.updateFirst(statement, parameter);
    }

    public UpdateResult updateMulti(String statement, Object parameter) {
        return this.mongoSessionProxy.updateMulti(statement, parameter);
    }

    public UpdateResult upsert(String statement, Object parameter) {
        return this.mongoSessionProxy.upsert(statement, parameter);
    }

    public <O> AggregationResults<O> aggregate(String statement, Object parameter) {
        return this.mongoSessionProxy.aggregate(statement, parameter);
    }

    public <T> T getMongoDao(Class<T> type) {
        return (T)this.getConfiguration().getMongoDao(type, (MongoSession)this);
    }

    private class MongoSessionIntercetor
    implements InvocationHandler {
        private MongoSessionIntercetor() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object unwrapped;
            block3: {
                MongoSession mongoSession = MongoSessionUtils.getMongoSession(MongoSessionTemplate.this.mongoSessionFactory, MongoSessionTemplate.this.executorType, MongoSessionTemplate.this.exceptionTranslator);
                try {
                    Object result;
                    unwrapped = result = method.invoke((Object)mongoSession, args);
                }
                catch (Throwable throwable) {
                    unwrapped = NestedExceptionUtils.getMostSpecificCause((Throwable)throwable);
                    if (MongoSessionTemplate.this.exceptionTranslator == null || !(unwrapped instanceof RuntimeException)) break block3;
                    mongoSession = null;
                    DataAccessException translated = MongoSessionTemplate.this.exceptionTranslator.translateExceptionIfPossible((RuntimeException)unwrapped);
                    if (translated != null) {
                        unwrapped = translated;
                    }
                    throw (Throwable)unwrapped;
                }
            }
            return unwrapped;
        }
    }
}

